/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.model.type;

import io.rxmicro.annotation.processor.common.model.LoggableClassName;
import io.rxmicro.annotation.processor.common.model.ModelField;
import io.rxmicro.annotation.processor.common.model.type.EnumModelClass;
import io.rxmicro.annotation.processor.common.model.type.IterableModelClass;
import io.rxmicro.annotation.processor.common.model.type.ObjectModelClass;
import io.rxmicro.annotation.processor.common.model.type.PrimitiveModelClass;
import java.util.Objects;

public abstract class ModelClass
implements Comparable<ModelClass>,
LoggableClassName {
    public abstract String getJavaSimpleClassName();

    public abstract String getJavaFullClassName();

    @Override
    public String getLoggableFullClassName() {
        return this.getJavaFullClassName();
    }

    public final boolean isPrimitive() {
        return this instanceof PrimitiveModelClass;
    }

    public final PrimitiveModelClass asPrimitive() {
        return (PrimitiveModelClass)this;
    }

    public final boolean isEnum() {
        return this instanceof EnumModelClass;
    }

    public final EnumModelClass asEnum() {
        return (EnumModelClass)this;
    }

    public final boolean isObject() {
        return this instanceof ObjectModelClass;
    }

    public final <F extends ModelField, T extends ObjectModelClass<F>> T asObject() {
        return (T)((ObjectModelClass)this);
    }

    public final <F extends ModelField, T extends ObjectModelClass<F>> T asObject(Class<T> className) {
        return (T)((ObjectModelClass)this);
    }

    public final boolean isIterable() {
        return this instanceof IterableModelClass;
    }

    public final IterableModelClass asIterable() {
        return (IterableModelClass)this;
    }

    public final int hashCode() {
        return this.getJavaFullClassName().hashCode();
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ModelClass that = (ModelClass)other;
        return Objects.equals(this.getJavaFullClassName(), that.getJavaFullClassName());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "#" + this.getJavaFullClassName();
    }

    @Override
    public final int compareTo(ModelClass other) {
        return this.getJavaFullClassName().compareTo(other.getJavaFullClassName());
    }
}

