/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.model.type;

import io.rxmicro.annotation.processor.common.model.type.EnumModelClass;
import io.rxmicro.annotation.processor.common.model.type.ModelClass;
import io.rxmicro.annotation.processor.common.model.type.ObjectModelClass;
import io.rxmicro.annotation.processor.common.model.type.PrimitiveModelClass;
import io.rxmicro.annotation.processor.common.util.Names;
import io.rxmicro.annotation.processor.common.util.ProcessingEnvironmentHelper;
import io.rxmicro.common.util.Requires;
import javax.lang.model.type.TypeMirror;

public final class IterableModelClass
extends ModelClass {
    private final ModelClass elementModelClass;
    private final TypeMirror containerType;
    private final String containerTypeName;

    public IterableModelClass(ModelClass elementModelClass, TypeMirror containerType) {
        this.elementModelClass = (ModelClass)Requires.require((Object)elementModelClass);
        this.containerType = containerType;
        this.containerTypeName = Names.getSimpleName(ProcessingEnvironmentHelper.getTypes().erasure(containerType));
    }

    public ModelClass getElementModelClass() {
        return this.elementModelClass;
    }

    public boolean isPrimitiveIterable() {
        return this.elementModelClass instanceof PrimitiveModelClass;
    }

    public boolean isObjectIterable() {
        return this.elementModelClass instanceof ObjectModelClass;
    }

    public boolean isEnumIterable() {
        return this.elementModelClass instanceof EnumModelClass;
    }

    public String getContainerType() {
        return this.containerTypeName;
    }

    public boolean isMap() {
        return "Map".equals(this.containerTypeName);
    }

    @Override
    public String getJavaSimpleClassName() {
        return Names.getSimpleName(this.containerType);
    }

    @Override
    public String getJavaFullClassName() {
        return this.containerType.toString();
    }
}

