/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.model.method;

import io.reactivex.rxjava3.core.Completable;
import io.rxmicro.annotation.processor.common.model.virtual.ClassWrapperTypeMirror;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.common.util.Names;
import io.rxmicro.annotation.processor.common.util.ProcessingEnvironmentHelper;
import io.rxmicro.annotation.processor.common.util.Reactives;
import io.rxmicro.common.util.Formats;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public final class MethodResult {
    private static final ClassWrapperTypeMirror VOID_RESULT_TYPE = new ClassWrapperTypeMirror(Void.class);
    private final TypeMirror reactiveType;
    private final boolean oneItem;
    private final boolean optional;
    private final TypeMirror resultType;
    private final boolean primitive;

    public static MethodResult createWithVoidResult(TypeMirror reactiveType) {
        return new MethodResult(reactiveType, true, false, VOID_RESULT_TYPE, false);
    }

    public static MethodResult createRxJavaResult(TypeMirror reactiveType, TypeMirror resultType, boolean primitive) {
        return new MethodResult(reactiveType, !Reactives.isFlowable(reactiveType), Reactives.isMaybe(reactiveType), resultType, primitive);
    }

    public static MethodResult createRxJavaResult(TypeMirror reactiveType, boolean oneItem, TypeMirror resultType, boolean primitive) {
        return new MethodResult(reactiveType, oneItem, false, resultType, primitive);
    }

    public static MethodResult createCompletableFutureResult(TypeMirror reactiveType, boolean oneItem, boolean optional, TypeMirror resultType, boolean primitive) {
        return new MethodResult(reactiveType, oneItem, optional, resultType, primitive);
    }

    public static MethodResult createProjectReactorResult(TypeMirror reactiveType, TypeMirror resultType, boolean primitive) {
        return new MethodResult(reactiveType, !Reactives.isFlux(reactiveType), false, resultType, primitive);
    }

    public static MethodResult createProjectReactorResult(TypeMirror reactiveType, boolean oneItem, TypeMirror resultType, boolean primitive) {
        return new MethodResult(reactiveType, oneItem, false, resultType, primitive);
    }

    private MethodResult(TypeMirror reactiveType, boolean oneItem, boolean optional, TypeMirror resultType, boolean primitive) {
        this.primitive = primitive;
        this.reactiveType = reactiveType;
        this.oneItem = oneItem;
        this.optional = optional;
        this.resultType = resultType;
    }

    public String getHumanReadableReturnType() {
        if (this.isCompletable()) {
            return Completable.class.getSimpleName();
        }
        if (this.oneItem) {
            return Formats.format((String)(this.optional && this.isFuture() ? "?<Optional<?>>" : "?<?>"), (Object[])new Object[]{Names.getSimpleName(this.reactiveType), Names.getSimpleName(this.resultType)});
        }
        return Formats.format((String)(this.isFlux() || this.isFlowable() ? "?<?>" : "?<List<?>>"), (Object[])new Object[]{Names.getSimpleName(this.reactiveType), Names.getSimpleName(this.resultType)});
    }

    public TypeMirror getReactiveType() {
        return this.reactiveType;
    }

    public String getSimpleReactiveType() {
        return Names.getSimpleName(this.reactiveType);
    }

    public boolean isOptional() {
        return this.optional;
    }

    public TypeMirror getResultType() {
        return this.resultType;
    }

    public boolean isReactiveType(Class<?> candidateClass) {
        return candidateClass.getName().equals(ProcessingEnvironmentHelper.getTypes().erasure(this.reactiveType).toString());
    }

    public boolean isResultType(Class<?> candidateClass) {
        return this.isResultType(candidateClass.getName());
    }

    public boolean isResultType(String candidateClass) {
        return candidateClass.equals(ProcessingEnvironmentHelper.getTypes().erasure(this.resultType).toString());
    }

    public String getSimpleResultType() {
        return Names.getSimpleName(this.resultType);
    }

    public boolean isOneItem() {
        return this.oneItem;
    }

    public boolean isMono() {
        return Reactives.isMono(this.reactiveType);
    }

    public boolean isMaybe() {
        return Reactives.isMaybe(this.reactiveType);
    }

    public boolean isSingle() {
        return Reactives.isSingle(this.reactiveType);
    }

    public boolean isCompletable() {
        return Reactives.isCompletable(this.reactiveType);
    }

    public boolean isFlux() {
        return Reactives.isFlux(this.reactiveType);
    }

    public boolean isFlowable() {
        return Reactives.isFlowable(this.reactiveType);
    }

    public boolean isFuture() {
        return Reactives.isFuture(this.reactiveType);
    }

    public boolean isVoid() {
        return this.isResultType(Void.class);
    }

    public boolean isBoolean() {
        return this.isResultType(Boolean.class);
    }

    public boolean isLong() {
        return this.isResultType(Long.class);
    }

    public boolean isInteger() {
        return this.isResultType(Integer.class);
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public boolean isEnum() {
        return Elements.asEnumElement(this.resultType).isPresent();
    }

    public Set<String> getRequiredImports() {
        HashSet<String> set = new HashSet<String>();
        set.add(ProcessingEnvironmentHelper.getTypes().erasure(this.reactiveType).toString());
        this.addRecursiveImports(set, this.resultType);
        if (this.oneItem && this.optional && !this.isMaybe()) {
            set.add(Optional.class.getName());
        }
        if (!(this.oneItem || this.isFlux() || this.isFlowable())) {
            set.add(List.class.getName());
        }
        return set;
    }

    private void addRecursiveImports(Set<String> set, TypeMirror type) {
        set.add(ProcessingEnvironmentHelper.getTypes().erasure(type).toString());
        if (type instanceof DeclaredType) {
            List<? extends TypeMirror> typeArguments = ((DeclaredType)type).getTypeArguments();
            for (TypeMirror typeMirror : typeArguments) {
                this.addRecursiveImports(set, typeMirror);
            }
        }
    }

    public String toString() {
        return this.getHumanReadableReturnType();
    }
}

