/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.model.method;

import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.common.util.Names;
import io.rxmicro.annotation.processor.common.util.ProcessingEnvironmentHelper;
import io.rxmicro.annotation.processor.common.util.validators.TypeValidators;
import io.rxmicro.common.util.Requires;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public final class MethodParameter {
    private final VariableElement variableElement;
    private final String simpleType;
    private final Set<String> imports;

    public MethodParameter(ExecutableElement method, VariableElement variableElement) {
        this.variableElement = (VariableElement)Requires.require((Object)variableElement);
        StringBuilder simpleTypeBuilder = new StringBuilder();
        this.imports = this.extractTypes(simpleTypeBuilder, (ExecutableElement)Requires.require((Object)method), variableElement.asType());
        this.simpleType = simpleTypeBuilder.toString();
    }

    private Set<String> extractTypes(StringBuilder simpleTypeBuilder, ExecutableElement method, TypeMirror type) {
        HashSet<String> set = new HashSet<String>();
        if (Elements.isGenericType(type)) {
            TypeValidators.validateGenericType(method, type, "Invalid method parameter type");
            this.extractGenerics(set, simpleTypeBuilder, type);
        } else if (!type.getKind().isPrimitive()) {
            set.add(type.toString());
            simpleTypeBuilder.append(Names.getSimpleName(type));
        } else {
            simpleTypeBuilder.append(type);
        }
        return set;
    }

    private void extractGenerics(Set<String> set, StringBuilder simpleTypeBuilder, TypeMirror type) {
        TypeMirror containerType = ProcessingEnvironmentHelper.getTypes().erasure(type);
        if (!containerType.getKind().isPrimitive()) {
            set.add(containerType.toString());
        }
        simpleTypeBuilder.append(Names.getSimpleName(containerType)).append('<');
        List<? extends TypeMirror> typeArguments = ((DeclaredType)type).getTypeArguments();
        for (int i = 0; i < typeArguments.size(); ++i) {
            TypeMirror item = typeArguments.get(i);
            if (Elements.isGenericType(item)) {
                this.extractGenerics(set, simpleTypeBuilder, item);
            } else {
                set.add(item.toString());
                simpleTypeBuilder.append(Names.getSimpleName(item));
            }
            if (i == typeArguments.size() - 1) continue;
            simpleTypeBuilder.append(',');
        }
        simpleTypeBuilder.append('>');
    }

    public String getName() {
        return this.variableElement.getSimpleName().toString();
    }

    public String getSimpleType() {
        return this.simpleType;
    }

    public TypeMirror getType() {
        return this.variableElement.asType();
    }

    public Set<String> getRequiredImports() {
        return this.imports;
    }

    public String toString() {
        return this.getSimpleType() + " " + this.getName();
    }
}

