/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.model.method;

import io.rxmicro.annotation.processor.common.util.Names;
import io.rxmicro.annotation.processor.common.util.ProcessingEnvironmentHelper;
import io.rxmicro.annotation.processor.common.util.Types;
import io.rxmicro.common.util.Formats;
import io.rxmicro.common.util.Requires;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.type.TypeMirror;

public final class MethodName {
    private final String simpleName;
    private final List<TypeMirror> parameterTypes;
    private final boolean isOverloaded;

    public MethodName(String simpleName, List<TypeMirror> parameterTypes, boolean isOverloaded) {
        this.simpleName = (String)Requires.require((Object)simpleName);
        this.parameterTypes = (List)Requires.require(parameterTypes);
        this.isOverloaded = isOverloaded;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getUniqueJavaName() {
        if (this.isOverloaded && !this.parameterTypes.isEmpty()) {
            return Formats.format((String)"??", (Object[])new Object[]{this.simpleName, this.parameterTypes.stream().map(t -> t.getKind().isPrimitive() ? t.toString() : Names.getSimpleName(t)).collect(Collectors.joining(""))});
        }
        return this.simpleName;
    }

    public List<String> getParamTypeClasses() {
        return this.parameterTypes.stream().map(t -> {
            if (t.getKind().isPrimitive()) {
                return Types.JAVA_PRIMITIVE_REPLACEMENT.get((Object)t.getKind()).getName() + ".TYPE";
            }
            return ProcessingEnvironmentHelper.getTypes().erasure((TypeMirror)t).toString() + ".class";
        }).collect(Collectors.toList());
    }
}

