/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.model.definition.impl;

import io.rxmicro.annotation.processor.common.model.definition.TypeDefinition;
import io.rxmicro.annotation.processor.common.model.definition.TypeDefinitions;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;

public final class TypeDefinitionsImpl<T extends TypeDefinition>
implements TypeDefinitions<T> {
    private final List<T> typeDefinitions;

    @SafeVarargs
    public TypeDefinitionsImpl(T ... typeDefinitions) {
        this.typeDefinitions = List.of(typeDefinitions);
    }

    public TypeDefinitionsImpl(List<TypeDefinitions<T>> typeDefinitions) {
        this.typeDefinitions = typeDefinitions.stream().flatMap(d -> d.getTypeDefinitions().stream()).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public boolean contains(TypeMirror typeMirror) {
        return this.typeDefinitions.stream().anyMatch(d -> d.isEqual(typeMirror));
    }

    @Override
    public boolean contains(Element element) {
        return this.typeDefinitions.stream().anyMatch(d -> d.isEqual(element));
    }

    @Override
    public Collection<T> getTypeDefinitions() {
        return this.typeDefinitions;
    }

    @Override
    public String toString() {
        return this.typeDefinitions.toString();
    }
}

