/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.model.definition.impl;

import io.rxmicro.annotation.processor.common.model.definition.TypeDefinition;
import io.rxmicro.annotation.processor.common.model.definition.impl.ByNameTypeDefinition;
import io.rxmicro.common.util.Formats;
import io.rxmicro.common.util.Requires;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public final class ContainerTypeDefinition
implements TypeDefinition {
    private final TypeDefinition ownerTypeDefinition;
    private final TypeDefinition itemTypeDefinition;

    public ContainerTypeDefinition(TypeDefinition ownerTypeDefinition, TypeDefinition itemTypeDefinition) {
        this.ownerTypeDefinition = (TypeDefinition)Requires.require((Object)ownerTypeDefinition);
        this.itemTypeDefinition = (TypeDefinition)Requires.require((Object)itemTypeDefinition);
    }

    public ContainerTypeDefinition(Class<?> containerClass) {
        this.ownerTypeDefinition = new ByNameTypeDefinition(containerClass);
        this.itemTypeDefinition = null;
    }

    public TypeDefinition getOwnerTypeDefinition() {
        return this.ownerTypeDefinition;
    }

    @Override
    public boolean isEqual(TypeMirror typeMirror) {
        boolean result = this.ownerTypeDefinition.isEqual(typeMirror);
        if (!result) {
            return false;
        }
        if (this.itemTypeDefinition != null && typeMirror instanceof DeclaredType) {
            List<? extends TypeMirror> typeArguments = ((DeclaredType)typeMirror).getTypeArguments();
            if (typeArguments.size() == 1) {
                return this.itemTypeDefinition.isEqual(typeArguments.get(0));
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isEqual(Element element) {
        boolean result = this.ownerTypeDefinition.isEqual(element);
        if (!result) {
            return false;
        }
        return this.isEqual(element.asType());
    }

    @Override
    public String toString() {
        if (this.itemTypeDefinition == null) {
            return this.ownerTypeDefinition.toString();
        }
        return Formats.format((String)"?<?>", (Object[])new Object[]{this.ownerTypeDefinition, this.itemTypeDefinition});
    }
}

