/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.model.definition;

import io.rxmicro.annotation.processor.common.model.definition.TypeDefinition;
import io.rxmicro.annotation.processor.common.model.definition.TypeDefinitions;
import io.rxmicro.annotation.processor.common.model.definition.impl.ByNameTypeDefinition;
import io.rxmicro.annotation.processor.common.model.definition.impl.ContainerTypeDefinition;
import io.rxmicro.annotation.processor.common.model.definition.impl.TypeDefinitionsImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import reactor.core.publisher.Mono;

public abstract class SupportedTypesProvider {
    private TypeDefinitions<TypeDefinition> primitiveTypes;
    private TypeDefinitions<ContainerTypeDefinition> collectionContainerTypes;
    private TypeDefinitions<ContainerTypeDefinition> primitiveContainerTypes;
    private TypeDefinitions<TypeDefinition> reactiveReturnTypes;
    private TypeDefinitions<TypeDefinition> resultReturnPrimitiveTypes;
    private TypeDefinitions<TypeDefinition> notEntityMethodParameterTypes;
    private TypeDefinitions<TypeDefinition> standardMethodParameterTypes;
    private TypeDefinitions<TypeDefinition> internalTypes;
    private Map<String, Class<?>> replacePrimitiveSuggestions;

    public final Optional<Class<?>> getReplacePrimitiveSuggestions(String currentClass) {
        if (this.replacePrimitiveSuggestions == null) {
            this.replacePrimitiveSuggestions = this.createReplacePrimitiveSuggestions().stream().collect(Collectors.toMap(e -> ((Class)e.getKey()).getName(), Map.Entry::getValue));
        }
        return Optional.ofNullable(this.replacePrimitiveSuggestions.get(currentClass));
    }

    public final TypeDefinitions<TypeDefinition> getPrimitives() {
        if (this.primitiveTypes == null) {
            this.primitiveTypes = this.createPrimitives();
        }
        return this.primitiveTypes;
    }

    public final TypeDefinitions<ContainerTypeDefinition> getCollectionContainers() {
        if (this.collectionContainerTypes == null) {
            this.collectionContainerTypes = this.createCollectionContainers();
        }
        return this.collectionContainerTypes;
    }

    public final TypeDefinitions<ContainerTypeDefinition> getPrimitiveContainers() {
        if (this.primitiveContainerTypes == null) {
            this.primitiveContainerTypes = this.createPrimitiveCollectionContainers();
        }
        return this.primitiveContainerTypes;
    }

    public final TypeDefinitions<TypeDefinition> getReactiveReturnTypes() {
        if (this.reactiveReturnTypes == null) {
            this.reactiveReturnTypes = this.createReactiveReturnTypes();
        }
        return this.reactiveReturnTypes;
    }

    public final TypeDefinitions<TypeDefinition> getResultReturnPrimitiveTypes() {
        if (this.resultReturnPrimitiveTypes == null) {
            this.resultReturnPrimitiveTypes = this.createResultReturnPrimitiveTypes();
        }
        return this.resultReturnPrimitiveTypes;
    }

    public final TypeDefinitions<TypeDefinition> getNotEntityMethodParameters() {
        if (this.notEntityMethodParameterTypes == null) {
            this.notEntityMethodParameterTypes = this.createNotEntityMethodParameters();
        }
        return this.notEntityMethodParameterTypes;
    }

    public final TypeDefinitions<TypeDefinition> getStandardMethodParameters() {
        if (this.standardMethodParameterTypes == null) {
            this.standardMethodParameterTypes = this.createStandardMethodParameterTypes();
        }
        return this.standardMethodParameterTypes;
    }

    public final TypeDefinitions<TypeDefinition> getInternalTypes() {
        if (this.internalTypes == null) {
            this.internalTypes = this.createInternalTypes();
        }
        return this.internalTypes;
    }

    public final boolean isModelPrimitive(TypeMirror typeMirror) {
        return this.getPrimitives().contains(typeMirror);
    }

    public final boolean isModelInternalType(Element owner) {
        return this.getInternalTypes().contains(owner);
    }

    public final boolean isModelPrimitiveList(TypeMirror typeMirror) {
        return this.getPrimitiveContainers().contains(typeMirror);
    }

    protected abstract TypeDefinitions<TypeDefinition> createPrimitives();

    protected TypeDefinitions<ContainerTypeDefinition> createPrimitiveCollectionContainers() {
        ArrayList<ContainerTypeDefinition> definitions = new ArrayList<ContainerTypeDefinition>();
        for (ContainerTypeDefinition typeDefinition : this.getCollectionContainers().getTypeDefinitions()) {
            TypeDefinition owner = typeDefinition.getOwnerTypeDefinition();
            for (TypeDefinition primitiveDefinition : this.getPrimitives().getTypeDefinitions()) {
                definitions.add(new ContainerTypeDefinition(owner, primitiveDefinition));
            }
        }
        return new TypeDefinitionsImpl((TypeDefinition[])definitions.toArray(new ContainerTypeDefinition[0]));
    }

    protected TypeDefinitions<ContainerTypeDefinition> createCollectionContainers() {
        return new TypeDefinitionsImpl((TypeDefinition[])new ContainerTypeDefinition[]{new ContainerTypeDefinition(List.class)});
    }

    protected TypeDefinitions<TypeDefinition> createReactiveReturnTypes() {
        return new TypeDefinitionsImpl(new TypeDefinition[]{new ByNameTypeDefinition(CompletionStage.class), new ByNameTypeDefinition(CompletableFuture.class), new ByNameTypeDefinition(Mono.class)});
    }

    protected TypeDefinitions<TypeDefinition> createResultReturnPrimitiveTypes() {
        return new TypeDefinitionsImpl<TypeDefinition>(List.of(this.getPrimitives(), new TypeDefinitionsImpl((TypeDefinition[])this.getPrimitiveContainers().getTypeDefinitions().stream().map(c -> c).toArray(TypeDefinition[]::new))));
    }

    protected TypeDefinitions<TypeDefinition> createNotEntityMethodParameters() {
        return new TypeDefinitionsImpl<TypeDefinition>(List.of(this.getPrimitives(), this.getStandardMethodParameters(), new TypeDefinitionsImpl((TypeDefinition[])this.getPrimitiveContainers().getTypeDefinitions().stream().map(c -> c).toArray(TypeDefinition[]::new))));
    }

    protected TypeDefinitions<TypeDefinition> createStandardMethodParameterTypes() {
        return new TypeDefinitionsImpl(new TypeDefinition[0]);
    }

    protected TypeDefinitions<TypeDefinition> createInternalTypes() {
        return new TypeDefinitionsImpl(new TypeDefinition[0]);
    }

    protected List<Map.Entry<Class<?>, Class<?>>> createReplacePrimitiveSuggestions() {
        return List.of();
    }
}

