/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.model;

import io.rxmicro.annotation.processor.common.util.SortedOperatorMapBuilder;
import io.rxmicro.common.util.ExCollections;
import io.rxmicro.common.util.Requires;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;

public final class TokenParserRule {
    private final boolean variablesSupported;
    private final Set<Character> ignoredDelimiter;
    private final Set<Character> stringDelimiter;
    private final Set<String> lineCommentStartedTokens;
    private final Set<String> multiLineCommentStartedTokens;
    private final Set<String> multiLineCommentFinishedTokens;
    private final Set<Character> multiLineCommentFinishedTokenFirstChars;
    private final Map<String, SortedSet<String>> sortedOperatorMap;

    private TokenParserRule(boolean variablesSupported, Set<Character> ignoredDelimiter, Set<Character> stringDelimiter, Set<String> lineCommentStartedTokens, Set<String> multiLineCommentStartedTokens, Set<String> multiLineCommentFinishedTokens, Map<String, SortedSet<String>> sortedOperatorMap) {
        this.variablesSupported = variablesSupported;
        this.ignoredDelimiter = (Set)Requires.require(ignoredDelimiter);
        this.stringDelimiter = (Set)Requires.require(stringDelimiter);
        this.lineCommentStartedTokens = (Set)Requires.require(lineCommentStartedTokens);
        this.multiLineCommentStartedTokens = (Set)Requires.require(multiLineCommentStartedTokens);
        this.multiLineCommentFinishedTokens = (Set)Requires.require(multiLineCommentFinishedTokens);
        this.multiLineCommentFinishedTokenFirstChars = multiLineCommentFinishedTokens.stream().map(s -> Character.valueOf(s.charAt(0))).collect(Collectors.toSet());
        this.sortedOperatorMap = (Map)Requires.require(sortedOperatorMap);
    }

    public boolean isIgnoredDelimiter(char ch) {
        return this.ignoredDelimiter.contains(Character.valueOf(ch));
    }

    public boolean isStringDelimiter(char ch) {
        return this.stringDelimiter.contains(Character.valueOf(ch));
    }

    public Map<String, SortedSet<String>> getSortedOperatorMap() {
        return this.sortedOperatorMap;
    }

    public boolean areVariablesSupported() {
        return this.variablesSupported;
    }

    public boolean isLineBlank(String line) {
        return line.isEmpty() || line.chars().allMatch(ch -> this.isIgnoredDelimiter((char)ch));
    }

    public boolean isLineStartsWithLineComment(String line) {
        return this.lineCommentStartedTokens.stream().anyMatch(line::startsWith);
    }

    public boolean isLineCommentToken(String token) {
        return this.lineCommentStartedTokens.contains(token);
    }

    public boolean isMultiLineCommentStartedToken(String token) {
        return this.multiLineCommentStartedTokens.contains(token);
    }

    public boolean isMultiLineCommentFinishedTokenCandidate(char ch) {
        return this.multiLineCommentFinishedTokenFirstChars.contains(Character.valueOf(ch));
    }

    public boolean isMultiLineCommentFinishedToken(String token) {
        return this.multiLineCommentFinishedTokens.contains(token);
    }

    public static final class Builder {
        private boolean variablesSupported;
        private Set<Character> ignoredDelimiter = Set.of(Character.valueOf(' '), Character.valueOf('\u00a0'), Character.valueOf('\n'), Character.valueOf('\t'), Character.valueOf('\r'));
        private Set<Character> stringDelimiter = Set.of(Character.valueOf('\''), Character.valueOf('\"'));
        private Set<String> lineCommentStartedTokens = Set.of();
        private Set<String> multiLineCommentStartedTokens = Set.of();
        private Set<String> multiLineCommentFinishedTokens = Set.of();
        private Set<String> operatorTokenDelimiters = Set.of();
        private Set<String> notOperatorTokenDelimiters = Set.of();

        public Builder setVariablesSupported(boolean variablesSupported) {
            this.variablesSupported = variablesSupported;
            return this;
        }

        public Builder setIgnoredDelimiter(Set<Character> ignoredDelimiter) {
            this.ignoredDelimiter = (Set)Requires.require(ignoredDelimiter);
            return this;
        }

        public Builder setStringDelimiter(Set<Character> stringDelimiter) {
            this.stringDelimiter = (Set)Requires.require(stringDelimiter);
            return this;
        }

        public Builder setLineCommentStartedTokens(Set<String> lineCommentStartedTokens) {
            this.lineCommentStartedTokens = (Set)Requires.require(lineCommentStartedTokens);
            return this;
        }

        public Builder setMultiLineCommentStartedTokens(Set<String> multiLineCommentStartedTokens) {
            this.multiLineCommentStartedTokens = (Set)Requires.require(multiLineCommentStartedTokens);
            return this;
        }

        public Builder setMultiLineCommentFinishedTokens(Set<String> multiLineCommentFinishedTokens) {
            this.multiLineCommentFinishedTokens = (Set)Requires.require(multiLineCommentFinishedTokens);
            return this;
        }

        public Builder setOperatorTokenDelimiters(Set<String> operatorTokenDelimiters) {
            this.operatorTokenDelimiters = (Set)Requires.require(operatorTokenDelimiters);
            return this;
        }

        public Builder setNotOperatorTokenDelimiters(Set<String> notOperatorTokenDelimiters) {
            this.notOperatorTokenDelimiters = (Set)Requires.require(notOperatorTokenDelimiters);
            return this;
        }

        public TokenParserRule build() {
            Set significantTokenDelimiters = ExCollections.join((Set[])new Set[]{this.operatorTokenDelimiters, this.notOperatorTokenDelimiters, this.lineCommentStartedTokens, this.multiLineCommentStartedTokens, this.multiLineCommentFinishedTokens});
            return new TokenParserRule(this.variablesSupported, this.ignoredDelimiter, this.stringDelimiter, this.lineCommentStartedTokens, this.multiLineCommentStartedTokens, this.multiLineCommentFinishedTokens, this.buildSortedOperatorMap(significantTokenDelimiters));
        }

        private Map<String, SortedSet<String>> buildSortedOperatorMap(Set<String> significantTokenDelimiters) {
            return new SortedOperatorMapBuilder(significantTokenDelimiters).buildUnmodifiableMapWithSortedValues((o1, o2) -> {
                int res = o2.length() - o1.length();
                return res == 0 ? o1.compareTo((String)o2) : res;
            });
        }
    }
}

