/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.model;

import io.rxmicro.annotation.processor.common.util.Annotations;
import io.rxmicro.annotation.processor.common.util.ProcessingEnvironmentHelper;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.type.DeclaredType;

public final class SupportedAnnotations {
    private final Set<String> names;
    private final Set<String> namesWithRepeatable;

    public SupportedAnnotations(Set<Class<? extends Annotation>> supportedAnnotationClasses) {
        TreeSet<String> supportedAnnotations = new TreeSet<String>();
        this.namesWithRepeatable = new LinkedHashSet<String>();
        for (Class<? extends Annotation> annotationClass : supportedAnnotationClasses) {
            supportedAnnotations.add(annotationClass.getName());
            this.namesWithRepeatable.add(annotationClass.getName());
            Optional.ofNullable(ProcessingEnvironmentHelper.getElements().getTypeElement(annotationClass.getName())).flatMap(annotationElement -> Optional.ofNullable(annotationElement.getAnnotation(Repeatable.class))).ifPresent(repeatable -> this.namesWithRepeatable.add(Annotations.getRequiredAnnotationClassParameter(repeatable::value).asType().toString()));
        }
        this.names = Collections.unmodifiableSet(supportedAnnotations);
    }

    public Set<String> getNames() {
        return this.names;
    }

    public boolean isAnnotationSupported(DeclaredType annotationType) {
        return this.namesWithRepeatable.contains(annotationType.toString());
    }
}

