/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.model;

import io.rxmicro.annotation.processor.common.util.GeneratedClassNames;
import io.rxmicro.annotation.processor.common.util.Names;
import io.rxmicro.common.util.Requires;
import javax.lang.model.type.TypeMirror;

public final class ModelTransformer
implements Comparable<ModelTransformer> {
    private final String packageName;
    private final String modelSimpleName;
    private final Class<?> baseTransformerClass;

    public ModelTransformer(TypeMirror modelFullClassName, Class<?> baseTransformerClass) {
        this.packageName = Names.getPackageName((TypeMirror)Requires.require((Object)modelFullClassName));
        this.modelSimpleName = Names.getSimpleName(modelFullClassName);
        this.baseTransformerClass = baseTransformerClass;
    }

    public String getJavaFullClassName() {
        return GeneratedClassNames.getModelTransformerFullClassName(this.packageName, this.modelSimpleName, this.baseTransformerClass);
    }

    public String getJavaSimpleClassName() {
        return GeneratedClassNames.getModelTransformerSimpleClassName(this.modelSimpleName, this.baseTransformerClass);
    }

    public String getInstanceName() {
        return GeneratedClassNames.getModelTransformerInstanceName(this.modelSimpleName, this.baseTransformerClass);
    }

    public int hashCode() {
        return this.getJavaFullClassName().hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ModelTransformer that = (ModelTransformer)other;
        return this.getJavaFullClassName().equals(that.getJavaFullClassName());
    }

    @Override
    public int compareTo(ModelTransformer other) {
        return this.getJavaFullClassName().compareTo(other.getJavaFullClassName());
    }
}

