/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.model;

import io.rxmicro.annotation.processor.common.model.AnnotatedModelElement;
import io.rxmicro.annotation.processor.common.model.ModelAccessorType;
import io.rxmicro.annotation.processor.common.util.Names;
import io.rxmicro.annotation.processor.common.util.ProcessingEnvironmentHelper;
import io.rxmicro.common.util.Formats;
import io.rxmicro.common.util.Requires;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public abstract class ModelField
implements Comparable<ModelField>,
Element {
    private final AnnotatedModelElement annotatedModelElement;
    private final String modelName;

    public ModelField(AnnotatedModelElement annotatedModelElement, String modelName) {
        this.annotatedModelElement = (AnnotatedModelElement)Requires.require((Object)annotatedModelElement);
        this.modelName = (String)Requires.require((Object)modelName);
    }

    public Element getFieldElement() {
        return this.annotatedModelElement.getField();
    }

    public <T extends Annotation> Element getElementAnnotatedBy(Class<T> annotationClass) {
        return this.annotatedModelElement.getElementAnnotatedBy(annotationClass).orElse(this.annotatedModelElement.getField());
    }

    public Element getElementAnnotatedBy(AnnotationMirror annotationMirror) {
        return this.annotatedModelElement.getElementAnnotatedBy(annotationMirror).orElse(this.annotatedModelElement.getField());
    }

    public final TypeMirror getFieldClass() {
        return this.annotatedModelElement.getField().asType();
    }

    public final String getFieldSimpleType() {
        return Names.getSimpleName(this.getFieldClass());
    }

    public final String getFieldName() {
        return this.annotatedModelElement.getField().getSimpleName().toString();
    }

    public final String getModelName() {
        return this.modelName;
    }

    @Override
    public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
        return this.annotatedModelElement.getAnnotationsByType(annotationType);
    }

    public <T extends Annotation> boolean hasAnnotation(Class<T> annotationClass) {
        return this.getAnnotation(annotationClass) != null;
    }

    public ModelAccessorType getModelReadAccessorType() {
        return this.annotatedModelElement.getModelReadAccessorType();
    }

    public ModelAccessorType getModelWriteAccessorType() {
        return this.annotatedModelElement.getModelWriteAccessorType();
    }

    public String getGetter() {
        return this.annotatedModelElement.getGetter();
    }

    public String getSetter() {
        return this.annotatedModelElement.getSetter();
    }

    public boolean isNotFinal() {
        return !this.annotatedModelElement.isFinal();
    }

    @Override
    public final int hashCode() {
        return this.getFieldFullName().hashCode();
    }

    @Override
    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ModelField that = (ModelField)other;
        return this.getFieldFullName().equals(that.getFieldFullName());
    }

    public String toString() {
        return Formats.format((String)"?: ?", (Object[])new Object[]{this.getClass().getSimpleName(), this.getFieldFullName()});
    }

    @Override
    public TypeMirror asType() {
        return this.getFieldElement().asType();
    }

    @Override
    public ElementKind getKind() {
        return this.getFieldElement().getKind();
    }

    @Override
    public Set<Modifier> getModifiers() {
        return this.getFieldElement().getModifiers();
    }

    @Override
    public Name getSimpleName() {
        return this.getFieldElement().getSimpleName();
    }

    @Override
    public Element getEnclosingElement() {
        return this.getFieldElement().getEnclosingElement();
    }

    @Override
    public List<? extends Element> getEnclosedElements() {
        return List.of();
    }

    @Override
    public List<? extends AnnotationMirror> getAnnotationMirrors() {
        return this.annotatedModelElement.getAllAnnotationMirrors(ProcessingEnvironmentHelper.getElements());
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.annotatedModelElement.getAnnotation(annotationClass);
    }

    @Override
    public <R, P> R accept(ElementVisitor<R, P> visitor, P parameter) {
        return this.getFieldElement().accept(visitor, parameter);
    }

    @Override
    public int compareTo(ModelField other) {
        return this.getFieldName().compareTo(other.getFieldName());
    }

    private String getFieldFullName() {
        return Formats.format((String)"?.?", (Object[])new Object[]{((TypeElement)this.getFieldElement().getEnclosingElement()).getQualifiedName().toString(), this.getFieldName()});
    }
}

