/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.model;

import io.rxmicro.annotation.processor.common.model.DefaultConfigProxyValue;
import io.rxmicro.annotation.processor.common.model.ModuleGeneratorConfig;
import io.rxmicro.annotation.processor.common.model.virtual.VirtualModuleElement;
import io.rxmicro.common.RxMicroModule;
import io.rxmicro.common.util.Requires;
import io.rxmicro.runtime.detail.RxMicroRuntime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;

public final class EnvironmentContext {
    private final Map<Class<? extends ModuleGeneratorConfig>, ModuleGeneratorConfig> moduleGeneratorConfigs = new HashMap<Class<? extends ModuleGeneratorConfig>, ModuleGeneratorConfig>();
    private final ModuleElement currentModule;
    private final Set<RxMicroModule> rxMicroModules;
    private final Set<String> includePackages;
    private final Set<String> excludePackages;
    private final List<Map.Entry<String, DefaultConfigProxyValue>> defaultConfigValues;
    private final List<String> packagesThatMustBeOpenedToRxMicroCommonModule;

    public EnvironmentContext(ModuleElement currentModule, Set<RxMicroModule> rxMicroModules, Set<String> includePackages, Set<String> excludePackages, List<Map.Entry<String, DefaultConfigProxyValue>> defaultConfigValues, List<String> packagesThatMustBeOpenedToRxMicroCommonModule) {
        this.currentModule = (ModuleElement)Requires.require((Object)currentModule);
        this.rxMicroModules = new TreeSet<RxMicroModule>(rxMicroModules);
        this.includePackages = (Set)Requires.require(includePackages);
        this.excludePackages = (Set)Requires.require(excludePackages);
        this.defaultConfigValues = (List)Requires.require(defaultConfigValues);
        this.packagesThatMustBeOpenedToRxMicroCommonModule = packagesThatMustBeOpenedToRxMicroCommonModule;
    }

    public ModuleElement getCurrentModule() {
        return this.currentModule;
    }

    public Set<RxMicroModule> getRxMicroModules() {
        return this.rxMicroModules;
    }

    public boolean isRxMicroModuleEnabled(RxMicroModule rxMicroModule) {
        return this.rxMicroModules.contains(rxMicroModule);
    }

    public void put(ModuleGeneratorConfig moduleGeneratorConfig) {
        this.moduleGeneratorConfigs.put(moduleGeneratorConfig.getClass(), moduleGeneratorConfig);
    }

    public <T extends ModuleGeneratorConfig> T get(Class<T> moduleGeneratorConfigClass) {
        return (T)Optional.ofNullable(this.moduleGeneratorConfigs.get(moduleGeneratorConfigClass)).orElseThrow();
    }

    public boolean isRxMicroClassShouldBeProcessed(TypeElement type) {
        if (!this.includePackages.isEmpty()) {
            return this.filterBy(this.includePackages, this.excludePackages, type, FilterType.INCLUDE);
        }
        return this.filterBy(this.excludePackages, Set.of(), type, FilterType.EXCLUDE);
    }

    private boolean filterBy(Set<String> packages, Set<String> exceptionPackages, TypeElement type, FilterType filterType) {
        if (packages.isEmpty()) {
            return true;
        }
        String fullClassName = type.getQualifiedName().toString();
        for (String ignoredPackage : packages) {
            if (!fullClassName.startsWith(ignoredPackage)) continue;
            if (exceptionPackages.isEmpty()) {
                return filterType.success;
            }
            return this.filterBy(exceptionPackages, Set.of(), type, FilterType.EXCLUDE);
        }
        return filterType.failed;
    }

    public List<Map.Entry<String, DefaultConfigProxyValue>> getDefaultConfigValues() {
        return this.defaultConfigValues;
    }

    public List<String> getPackagesThatMustBeOpenedToRxMicroCommonModule() {
        return this.packagesThatMustBeOpenedToRxMicroCommonModule;
    }

    public String toString() {
        return "Current environment context is:" + System.lineSeparator() + "  RxMicro version: " + RxMicroRuntime.getRxMicroVersion() + System.lineSeparator() + "  Current module:" + System.lineSeparator() + "    `" + this.getModuleName() + "`" + System.lineSeparator() + "  Available RxMicro modules: " + System.lineSeparator() + this.rxMicroModules.stream().map(s -> "    `" + s + "`;").collect(Collectors.joining(System.lineSeparator())) + System.lineSeparator() + "  Include packages:" + (String)(this.includePackages.isEmpty() ? " <none>" : System.lineSeparator() + this.includePackages.stream().map(s -> "    " + s + ".*").collect(Collectors.joining(System.lineSeparator()))) + System.lineSeparator() + "  Exclude packages:" + (String)(this.excludePackages.isEmpty() ? " <none>" : System.lineSeparator() + this.excludePackages.stream().map(s -> "    " + s + ".*").collect(Collectors.joining(System.lineSeparator())));
    }

    private CharSequence getModuleName() {
        if (this.currentModule instanceof VirtualModuleElement || !this.currentModule.isUnnamed()) {
            return this.currentModule.getQualifiedName();
        }
        return "UNNAMED";
    }

    private static enum FilterType {
        INCLUDE(true, false),
        EXCLUDE(false, true);

        private final boolean success;
        private final boolean failed;

        private FilterType(boolean success, boolean failed) {
            this.success = success;
            this.failed = failed;
        }
    }
}

