/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.model;

import io.rxmicro.annotation.processor.common.model.error.InternalErrorException;
import io.rxmicro.annotation.processor.common.model.type.ObjectModelClass;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.common.util.Names;
import io.rxmicro.annotation.processor.common.util.ProcessingEnvironmentHelper;
import io.rxmicro.common.CheckedWrapperException;
import io.rxmicro.common.InvalidStateException;
import io.rxmicro.common.util.Formats;
import io.rxmicro.common.util.Requires;
import io.rxmicro.reflection.Reflections;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public final class ClassHeader {
    private final String packageName;
    private final Map<String, String> importsMap;
    private final Map<String, String> staticImportsMap;

    public static Builder newClassHeaderBuilder(String packageName) {
        return new Builder(packageName);
    }

    public static Builder newClassHeaderBuilder(TypeElement typeElement) {
        return ClassHeader.newClassHeaderBuilder(Names.getPackageName(typeElement));
    }

    public static Builder newClassHeaderBuilder(ObjectModelClass<?> objectModelClass) {
        return ClassHeader.newClassHeaderBuilder(objectModelClass.getModelTypeElement());
    }

    private ClassHeader(String packageName, Set<String> imports, Set<String> staticImports) {
        this.packageName = packageName;
        this.importsMap = imports.stream().map(cl -> Map.entry(Names.getSimpleName(cl), cl)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> {
            throw new InvalidStateException("Detected different classes with the same simple name: '?' and '?'", new Object[]{v1, v2});
        }));
        this.staticImportsMap = staticImports.stream().map(cl -> Map.entry(Names.getSimpleName(cl), cl)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> {
            throw new InvalidStateException("Detected different static methods with the same simple name: '?' and '?'", new Object[]{v1, v2});
        }));
    }

    public Map<String, String> getEditableImports() {
        return this.importsMap;
    }

    public Map<String, String> getEditableStaticImports() {
        return this.staticImportsMap;
    }

    public String buildHeader(boolean withAuthorComment) {
        TreeSet<String> javaImports = new TreeSet<String>();
        TreeSet<String> libImports = new TreeSet<String>();
        TreeSet<String> staticImports = new TreeSet<String>(this.staticImportsMap.values());
        for (String className : this.importsMap.values()) {
            String packageName = Names.getPackageName(className);
            if (this.packageName.equals(packageName) || "java.lang".equals(packageName)) continue;
            if (packageName.startsWith("java.")) {
                javaImports.add(className);
                continue;
            }
            libImports.add(className);
        }
        return this.buildHeader(withAuthorComment, javaImports, libImports, staticImports);
    }

    private String buildHeader(boolean withAuthorComment, Set<String> javaImports, Set<String> libImports, Set<String> staticImports) {
        StringBuilder headerBuilder = new StringBuilder(50);
        headerBuilder.append("package ").append(this.packageName).append(';').append(System.lineSeparator()).append(System.lineSeparator());
        for (Set imports : Arrays.asList(libImports, javaImports, staticImports)) {
            String startStatement = imports.equals(staticImports) ? "import static " : "import ";
            for (String imp : imports) {
                headerBuilder.append(startStatement).append(imp).append(';').append(System.lineSeparator());
            }
            if (imports.isEmpty()) continue;
            headerBuilder.append(System.lineSeparator());
        }
        if (withAuthorComment) {
            headerBuilder.append(this.getAuthorComment());
        }
        return headerBuilder.toString();
    }

    public String getAuthorComment() {
        return "/**" + System.lineSeparator() + " * Generated by {@code RxMicro Annotation Processor}" + System.lineSeparator() + " */";
    }

    public static final class Builder {
        private static final TypeMirror[] EMPTY_TYPE_MIRROR_ARRAY = new TypeMirror[0];
        private final String packageName;
        private final Set<String> imports = new HashSet<String>();
        private final Set<String> staticImports = new HashSet<String>();

        private Builder(String packageName) {
            this.packageName = (String)Requires.require((Object)packageName);
        }

        public Builder addImports(TypeElement ... types) {
            Arrays.stream(types).forEach(t -> this.addImport(t.getQualifiedName().toString()));
            return this;
        }

        public Builder addImports(TypeMirror ... types) {
            Arrays.stream(types).flatMap(this::expand).forEach(t -> Elements.asTypeElement(t).ifPresent(te -> this.addImport(t.toString())));
            return this;
        }

        public Builder addImports(Class<?> ... classes) {
            Arrays.stream(classes).forEach(cl -> this.addImport(cl.getName()));
            return this;
        }

        public Builder addImports(String ... fullClassNames) {
            for (String fullClassName : fullClassNames) {
                this.addImport(fullClassName);
            }
            return this;
        }

        public Builder addImports(Collection<TypeMirror> fullClassNames) {
            this.addImports(fullClassNames.toArray(EMPTY_TYPE_MIRROR_ARRAY));
            return this;
        }

        private void addImport(String fullClassName) {
            this.imports.add(fullClassName);
        }

        public Builder addStaticImport(Class<?> className, String methodOrFieldName) {
            try {
                this.validateMethodName(className, methodOrFieldName);
            }
            catch (CheckedWrapperException ignore) {
                this.validateFieldName(className, methodOrFieldName);
            }
            this.addStaticImport(className.getName(), methodOrFieldName);
            return this;
        }

        public Builder addStaticImport(String className, String methodOrFieldName) {
            this.staticImports.add(Formats.format((String)"?.?", (Object[])new Object[]{className, methodOrFieldName}));
            return this;
        }

        private void validateMethodName(Class<?> className, String methodOrFieldName) {
            Reflections.getValidatedMethodName(className, (String)methodOrFieldName);
        }

        private void validateFieldName(Class<?> className, String methodOrFieldName) {
            try {
                Reflections.getValidatedFieldName(className, (String)methodOrFieldName);
            }
            catch (CheckedWrapperException ignore) {
                throw new InternalErrorException("'?' class does not contain public field or method with '?' name!", className, methodOrFieldName);
            }
        }

        private Stream<TypeMirror> expand(TypeMirror type) {
            ArrayList<TypeMirror> result = new ArrayList<TypeMirror>(2);
            this.populate(result, type);
            return result.stream();
        }

        private void populate(List<TypeMirror> result, TypeMirror type) {
            if (type instanceof DeclaredType) {
                for (TypeMirror typeMirror : ((DeclaredType)type).getTypeArguments()) {
                    this.populate(result, typeMirror);
                }
            }
            result.add(ProcessingEnvironmentHelper.getTypes().erasure(type));
        }

        public ClassHeader build() {
            return new ClassHeader(this.packageName, this.imports, this.staticImports);
        }
    }
}

