/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.model;

import io.rxmicro.annotation.processor.common.model.ModelAccessorType;
import io.rxmicro.annotation.processor.common.model.error.InternalErrorException;
import io.rxmicro.common.util.Requires;
import io.rxmicro.model.MappingStrategy;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;

public final class AnnotatedModelElement {
    private final VariableElement field;
    private final List<ExecutableElement> getters;
    private final ExecutableElement setter;
    private final ModelAccessorType readModelAccessorType;
    private final ModelAccessorType writeModelAccessorType;

    public AnnotatedModelElement(VariableElement field, List<ExecutableElement> getters, ExecutableElement setter) {
        this.field = (VariableElement)Requires.require((Object)field);
        this.getters = (List)Requires.require(getters);
        this.setter = setter;
        this.readModelAccessorType = this.getModelAccessorType(() -> !getters.isEmpty());
        this.writeModelAccessorType = this.getModelAccessorType(() -> setter != null);
    }

    public AnnotatedModelElement(VariableElement constructorArgument) {
        this.field = (VariableElement)Requires.require((Object)constructorArgument);
        this.getters = List.of();
        this.setter = null;
        this.readModelAccessorType = constructorArgument.getModifiers().contains((Object)Modifier.PRIVATE) ? ModelAccessorType.REFLECTION : ModelAccessorType.DIRECT;
        this.writeModelAccessorType = constructorArgument.getModifiers().contains((Object)Modifier.PRIVATE) ? ModelAccessorType.REFLECTION : ModelAccessorType.DIRECT;
    }

    String getGetter() {
        try {
            return this.getters.get(0).getSimpleName().toString();
        }
        catch (IndexOutOfBoundsException ignore) {
            throw new InternalErrorException("Getter not defined: class=?, field=?", this.field.getEnclosingElement().asType(), this.field.getSimpleName());
        }
    }

    String getSetter() {
        if (this.setter == null) {
            throw new InternalErrorException("Setter not defined: class=?, field=?", this.field.getEnclosingElement().asType(), this.field.getSimpleName());
        }
        return this.setter.getSimpleName().toString();
    }

    ModelAccessorType getModelReadAccessorType() {
        return this.readModelAccessorType;
    }

    ModelAccessorType getModelWriteAccessorType() {
        return this.writeModelAccessorType;
    }

    private ModelAccessorType getModelAccessorType(Supplier<Boolean> javaBeanUsagePredicate) {
        if (this.field.getModifiers().contains((Object)Modifier.PRIVATE)) {
            if (javaBeanUsagePredicate.get().booleanValue()) {
                return ModelAccessorType.JAVA_BEAN;
            }
            return ModelAccessorType.REFLECTION;
        }
        return ModelAccessorType.DIRECT;
    }

    public VariableElement getField() {
        return this.field;
    }

    public <T extends Annotation> boolean isAnnotationPresent(Class<T> annotationClass) {
        return this.getAnnotation(annotationClass) != null;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)((Annotation)Stream.concat(this.getters.stream(), Stream.of(this.field)).flatMap(e -> Optional.ofNullable(e.getAnnotation(annotationClass)).stream()).findFirst().orElse(null));
    }

    public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
        return (Annotation[])Stream.concat(this.getters.stream(), Stream.of(this.field)).flatMap(e -> Arrays.stream(e.getAnnotationsByType(annotationType))).toArray(value -> (Annotation[])Array.newInstance(annotationType, value));
    }

    public <T extends Annotation> Optional<Element> getElementAnnotatedBy(Class<T> annotationClass) {
        return Stream.concat(this.getters.stream(), Stream.of(this.field).map(e -> e)).filter(e -> e.getAnnotation(annotationClass) != null).findFirst();
    }

    Optional<Element> getElementAnnotatedBy(AnnotationMirror annotationMirror) {
        String annotationClassName = annotationMirror.getAnnotationType().toString();
        return Stream.concat(this.getters.stream(), Stream.of(this.field).map(e -> e)).filter(e -> e.getAnnotationMirrors().stream().anyMatch(m -> m.getAnnotationType().toString().equals(annotationClassName))).findFirst();
    }

    public List<? extends AnnotationMirror> getAllAnnotationMirrors(Elements elements) {
        TreeSet<AnnotationMirror> set = new TreeSet<AnnotationMirror>(Comparator.comparing(o -> o.getAnnotationType().toString()));
        Stream.concat(this.getters.stream(), Stream.of(this.field).map(e -> e)).forEach(e -> set.addAll(elements.getAllAnnotationMirrors((Element)e)));
        return new ArrayList<AnnotationMirror>(set);
    }

    public boolean isFinal() {
        return this.field.getModifiers().contains((Object)Modifier.FINAL);
    }

    public String getModelName(String customModelName, Annotation mappingStrategyAnnotation, Supplier<MappingStrategy> mappingStrategySupplier) {
        if (!customModelName.isEmpty()) {
            return customModelName;
        }
        if (mappingStrategyAnnotation != null) {
            return mappingStrategySupplier.get().getModelName(this.field.getSimpleName().toString());
        }
        return this.field.getSimpleName().toString();
    }
}

