/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.component.impl.reactive;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.component.impl.ReactiveMethodResultBuilder;
import io.rxmicro.annotation.processor.common.model.definition.SupportedTypesProvider;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.model.method.MethodResult;
import io.rxmicro.annotation.processor.common.util.Names;
import io.rxmicro.annotation.processor.common.util.ProcessingEnvironmentHelper;
import io.rxmicro.annotation.processor.common.util.Reactives;
import io.rxmicro.annotation.processor.common.util.validators.TypeValidators;
import java.util.Optional;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

@Singleton
public final class SpringReactorReactiveMethodResultBuilder
implements ReactiveMethodResultBuilder {
    @Override
    public boolean isSupport(ExecutableElement method) {
        return Reactives.isSpringReactorType(method.getReturnType());
    }

    @Override
    public MethodResult build(ExecutableElement method, SupportedTypesProvider supportedTypesProvider) {
        TypeMirror returnType = method.getReturnType();
        TypeValidators.validateGenericType(method, returnType, "Invalid return type");
        TypeMirror reactiveType = ProcessingEnvironmentHelper.getTypes().erasure(returnType);
        TypeMirror genericType = ((DeclaredType)returnType).getTypeArguments().get(0);
        this.validateNotOptional(method, reactiveType, genericType);
        boolean isGenericList = supportedTypesProvider.getCollectionContainers().contains(ProcessingEnvironmentHelper.getTypes().erasure(genericType));
        this.validateNotGenericListIfFlux(method, reactiveType, genericType, isGenericList);
        if (isGenericList) {
            TypeValidators.validateGenericType(method, genericType, "Invalid return type");
            TypeMirror resultType = ((DeclaredType)genericType).getTypeArguments().get(0);
            boolean primitive = supportedTypesProvider.getResultReturnPrimitiveTypes().contains(resultType);
            return MethodResult.createProjectReactorResult(reactiveType, false, resultType, primitive);
        }
        boolean primitive = supportedTypesProvider.getResultReturnPrimitiveTypes().contains(genericType);
        return MethodResult.createProjectReactorResult(reactiveType, genericType, primitive);
    }

    private void validateNotOptional(ExecutableElement method, TypeMirror reactiveType, TypeMirror genericType) {
        if (ProcessingEnvironmentHelper.getTypes().erasure(genericType).toString().equals(Optional.class.getName())) {
            if (Reactives.isMono(reactiveType)) {
                throw new InterruptProcessingException(method, "Mono type already supports optional logic. Replace Mono<Optional<TYPE>> by Mono<TYPE>!", new Object[0]);
            }
            if (Reactives.isFlux(reactiveType)) {
                throw new InterruptProcessingException(method, "Flux type already supports optional logic. Replace Flux<Optional<TYPE>> by Flux<TYPE>!", new Object[0]);
            }
        }
    }

    private void validateNotGenericListIfFlux(ExecutableElement method, TypeMirror reactiveType, TypeMirror genericType, boolean genericList) {
        if (genericList && Reactives.isFlux(reactiveType)) {
            throw new InterruptProcessingException(method, "Flux type already supports iterable logic. Replace Flux<?<TYPE>> by Flux<TYPE>!", Names.getSimpleName(ProcessingEnvironmentHelper.getTypes().erasure(genericType).toString()));
        }
    }
}

