/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.component.impl.reactive;

import com.google.inject.Singleton;
import io.reactivex.rxjava3.core.Completable;
import io.rxmicro.annotation.processor.common.component.impl.ReactiveMethodResultBuilder;
import io.rxmicro.annotation.processor.common.model.definition.SupportedTypesProvider;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.model.method.MethodResult;
import io.rxmicro.annotation.processor.common.util.Names;
import io.rxmicro.annotation.processor.common.util.ProcessingEnvironmentHelper;
import io.rxmicro.annotation.processor.common.util.Reactives;
import io.rxmicro.annotation.processor.common.util.validators.TypeValidators;
import java.util.Optional;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

@Singleton
public final class RxJavaReactiveMethodResultBuilder
implements ReactiveMethodResultBuilder {
    @Override
    public boolean isSupport(ExecutableElement method) {
        return Reactives.isRxJavaType(method.getReturnType());
    }

    @Override
    public MethodResult build(ExecutableElement method, SupportedTypesProvider supportedTypesProvider) {
        TypeMirror returnType = method.getReturnType();
        if (Reactives.isCompletable(returnType)) {
            return MethodResult.createWithVoidResult(returnType);
        }
        TypeValidators.validateGenericType(method, returnType, "Invalid return type");
        TypeMirror reactiveType = ProcessingEnvironmentHelper.getTypes().erasure(returnType);
        TypeMirror genericType = ((DeclaredType)returnType).getTypeArguments().get(0);
        this.validateNotVoid(method, genericType);
        this.validateNotOptional(method, reactiveType, genericType);
        boolean isGenericList = supportedTypesProvider.getCollectionContainers().contains(ProcessingEnvironmentHelper.getTypes().erasure(genericType));
        this.validateGenericListIfSingleOnly(method, reactiveType, genericType, isGenericList);
        if (isGenericList) {
            TypeValidators.validateGenericType(method, genericType, "Invalid return type");
            TypeMirror resultType = ((DeclaredType)genericType).getTypeArguments().get(0);
            boolean primitive = supportedTypesProvider.getResultReturnPrimitiveTypes().contains(resultType);
            return MethodResult.createRxJavaResult(reactiveType, false, resultType, primitive);
        }
        TypeMirror resultType = genericType;
        boolean primitive = supportedTypesProvider.getResultReturnPrimitiveTypes().contains(resultType);
        return MethodResult.createRxJavaResult(reactiveType, resultType, primitive);
    }

    private void validateNotVoid(ExecutableElement method, TypeMirror genericType) {
        if (genericType.toString().equals(Void.class.getName())) {
            throw new InterruptProcessingException(method, "Return type '?' is invalid. Use '?' instead!", Names.getSimpleName(method.getReturnType()), Completable.class.getSimpleName());
        }
    }

    private void validateNotOptional(ExecutableElement method, TypeMirror reactiveType, TypeMirror genericType) {
        if (ProcessingEnvironmentHelper.getTypes().erasure(genericType).toString().equals(Optional.class.getName())) {
            if (Reactives.isSingle(reactiveType)) {
                throw new InterruptProcessingException(method, "Single type does not support optional logic. Use Maybe instead! Replace Single<Optional<TYPE>> by Maybe<TYPE>!", new Object[0]);
            }
            if (Reactives.isMaybe(reactiveType)) {
                throw new InterruptProcessingException(method, "Maybe type already supports optional logic. Replace Maybe<Optional<TYPE>> by Maybe<TYPE>!", new Object[0]);
            }
            if (Reactives.isFlowable(reactiveType)) {
                throw new InterruptProcessingException(method, "Flowable type already supports optional logic. Replace Flowable<Optional<TYPE>> by Flowable<TYPE>!", new Object[0]);
            }
        }
    }

    private void validateGenericListIfSingleOnly(ExecutableElement method, TypeMirror reactiveType, TypeMirror genericType, boolean genericList) {
        if (genericList && !Reactives.isSingle(reactiveType)) {
            String type = Names.getSimpleName(ProcessingEnvironmentHelper.getTypes().erasure(genericType).toString());
            throw new InterruptProcessingException(method, "Only Single could be parametrized by ?<TYPE>. Replace ?<?<TYPE>> by Single<?<TYPE>>", type, Names.getSimpleName(ProcessingEnvironmentHelper.getTypes().erasure(reactiveType)), type, type);
        }
    }
}

