/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.component.impl.reactive;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.component.impl.ReactiveMethodResultBuilder;
import io.rxmicro.annotation.processor.common.model.definition.SupportedTypesProvider;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.model.method.MethodResult;
import io.rxmicro.annotation.processor.common.util.Names;
import io.rxmicro.annotation.processor.common.util.ProcessingEnvironmentHelper;
import io.rxmicro.annotation.processor.common.util.Reactives;
import io.rxmicro.annotation.processor.common.util.validators.TypeValidators;
import java.util.Optional;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

@Singleton
public final class JSECompletableFutureReactiveMethodResultBuilder
implements ReactiveMethodResultBuilder {
    @Override
    public boolean isSupport(ExecutableElement method) {
        return Reactives.isFuture(method.getReturnType());
    }

    @Override
    public MethodResult build(ExecutableElement method, SupportedTypesProvider supportedTypesProvider) {
        boolean optional;
        boolean oneItem;
        TypeMirror resultType;
        TypeMirror returnType = method.getReturnType();
        TypeValidators.validateGenericType(method, returnType, "Invalid return type");
        TypeMirror reactiveType = ProcessingEnvironmentHelper.getTypes().erasure(returnType);
        TypeMirror genericType = ((DeclaredType)returnType).getTypeArguments().get(0);
        boolean isGenericList = supportedTypesProvider.getCollectionContainers().contains(ProcessingEnvironmentHelper.getTypes().erasure(genericType));
        if (isGenericList) {
            TypeValidators.validateGenericType(method, genericType, "Invalid return type");
            resultType = ((DeclaredType)genericType).getTypeArguments().get(0);
            oneItem = false;
            optional = false;
        } else if (ProcessingEnvironmentHelper.getTypes().erasure(genericType).toString().equals(Optional.class.getName())) {
            TypeValidators.validateGenericType(method, genericType, "Invalid return type");
            resultType = ((DeclaredType)genericType).getTypeArguments().get(0);
            this.validateNotVoid(method, resultType);
            oneItem = true;
            optional = true;
        } else {
            resultType = genericType;
            oneItem = true;
            optional = false;
        }
        boolean primitive = supportedTypesProvider.getResultReturnPrimitiveTypes().contains(resultType);
        return MethodResult.createCompletableFutureResult(reactiveType, oneItem, optional, resultType, primitive);
    }

    private void validateNotVoid(ExecutableElement method, TypeMirror resultType) {
        if (Void.class.getName().equals(resultType.toString())) {
            throw new InterruptProcessingException(method, "Void does not support optional logic. Use ?<Void> instead of ?<Optional<Void>!", Names.getSimpleName(ProcessingEnvironmentHelper.getTypes().erasure(method.getReturnType())));
        }
    }
}

