/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.component.WithParentClassStructureInitializer;
import io.rxmicro.annotation.processor.common.component.impl.BaseProcessorComponent;
import io.rxmicro.annotation.processor.common.model.ClassStructure;
import io.rxmicro.annotation.processor.common.model.ModelField;
import io.rxmicro.annotation.processor.common.model.WithParentClassStructure;
import io.rxmicro.annotation.processor.common.model.type.ObjectModelClass;
import io.rxmicro.annotation.processor.common.util.LoggerMessages;
import java.util.Collection;

@Singleton
public final class WithParentClassStructureInitializerImpl
extends BaseProcessorComponent
implements WithParentClassStructureInitializer {
    @Override
    public <CS extends ClassStructure, MF extends ModelField, MC extends ObjectModelClass<MF>> void setParentIfExists(Collection<CS> classStructureCandidates) {
        for (ClassStructure currentItem : classStructureCandidates) {
            this.setParent(classStructureCandidates, currentItem);
        }
    }

    private <CS extends ClassStructure, MF extends ModelField, MC extends ObjectModelClass<MF>> void setParent(Collection<CS> classStructureCandidates, CS currentItem) {
        Object modelClass = ((WithParentClassStructure)((Object)currentItem)).getModelClass();
        for (ObjectModelClass<MF> parent : ((ObjectModelClass)modelClass).getAllParents()) {
            String javaFullClassName = parent.getJavaFullClassName();
            for (ClassStructure classStructureCandidate : classStructureCandidates) {
                if (currentItem.equals(classStructureCandidate) || !((ObjectModelClass)((WithParentClassStructure)((Object)classStructureCandidate)).getModelClass()).getJavaFullClassName().equals(javaFullClassName)) continue;
                if (((WithParentClassStructure)((Object)currentItem)).assignParent(classStructureCandidate)) {
                    this.debug("Set parent class structure:\n?", () -> LoggerMessages.getLoggableParentChildRelationFragment(0, true, classStructureCandidate, currentItem));
                }
                return;
            }
        }
    }
}

