/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.component.TokenParser;
import io.rxmicro.annotation.processor.common.model.TokenParserResult;
import io.rxmicro.annotation.processor.common.model.TokenParserRule;
import io.rxmicro.common.model.StringIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;

@Singleton
public final class TokenParserImpl
implements TokenParser {
    @Override
    public TokenParserResult parse(String line, TokenParserRule rule, boolean multilineCommentStarted) {
        if (rule.isLineBlank(line)) {
            return new TokenParserResult(multilineCommentStarted);
        }
        if (!multilineCommentStarted && rule.isLineStartsWithLineComment(line)) {
            return new TokenParserResult(false);
        }
        ArrayList<String> tokens = new ArrayList<String>();
        StringIterator iterator = new StringIterator(line);
        boolean multilineCommentStartedResult = this.extractTokens(rule, tokens, iterator, multilineCommentStarted);
        return new TokenParserResult(tokens, multilineCommentStartedResult);
    }

    private boolean extractTokens(TokenParserRule rule, List<String> tokens, StringIterator iterator, boolean multilineCommentStarted) {
        StringBuilder tokenBuilder = new StringBuilder();
        boolean multilineCommentStartedResult = multilineCommentStarted;
        while (iterator.next()) {
            char ch = iterator.getCurrent();
            if (multilineCommentStartedResult) {
                if (!rule.isMultiLineCommentFinishedTokenCandidate(ch) || !rule.isMultiLineCommentFinishedToken(this.readOperatorToken(rule.getSortedOperatorMap(), ch, iterator))) continue;
                multilineCommentStartedResult = false;
                continue;
            }
            if (rule.isIgnoredDelimiter(ch)) {
                this.addTokenIfPresent(tokens, tokenBuilder);
                continue;
            }
            if (rule.isStringDelimiter(ch)) {
                this.addTokenIfPresent(tokens, tokenBuilder);
                tokens.add(this.readStringToken(ch, iterator));
                continue;
            }
            if (this.isOperator(rule.getSortedOperatorMap(), ch)) {
                this.addTokenIfPresent(tokens, tokenBuilder);
                String operator = this.readOperatorToken(rule.getSortedOperatorMap(), ch, iterator);
                if (rule.isLineCommentToken(operator)) {
                    return false;
                }
                if (rule.isMultiLineCommentStartedToken(operator)) {
                    multilineCommentStartedResult = true;
                    continue;
                }
                tokens.add(operator);
                continue;
            }
            if (ch == '$') {
                if (!this.resolveVariables(rule, tokens, iterator, tokenBuilder, ch)) continue;
                break;
            }
            tokenBuilder.append(ch);
        }
        this.addTokenIfPresent(tokens, tokenBuilder);
        return multilineCommentStartedResult;
    }

    private boolean isOperator(Map<String, SortedSet<String>> sortedOperatorMap, char ch) {
        return sortedOperatorMap.containsKey(String.valueOf(ch));
    }

    private String readVariableToken(StringIterator iterator) {
        StringBuilder stringBuilder = new StringBuilder().append("${");
        while (iterator.next()) {
            char ch = iterator.getCurrent();
            stringBuilder.append(ch);
            if ('}' != ch) continue;
            return stringBuilder.toString();
        }
        return stringBuilder.toString();
    }

    private String readStringToken(char firstChar, StringIterator iterator) {
        StringBuilder stringBuilder = new StringBuilder().append(firstChar);
        while (iterator.next()) {
            char ch = iterator.getCurrent();
            stringBuilder.append(ch);
            if (firstChar != ch) continue;
            return stringBuilder.toString();
        }
        return stringBuilder.toString();
    }

    private String readOperatorToken(Map<String, SortedSet<String>> sortedOperatorMap, char operator, StringIterator iterator) {
        String op = String.valueOf(operator);
        Set possibleOperators = sortedOperatorMap.get(op);
        if (possibleOperators.isEmpty()) {
            return op;
        }
        return this.readOperatorToken(operator, iterator, possibleOperators);
    }

    private String readOperatorToken(char operator, StringIterator iterator, Set<String> possibleOperators) {
        StringBuilder actualValue = new StringBuilder().append(operator);
        this.fillActualValue(actualValue, iterator, this.getMaxPossibleOperatorLength(possibleOperators) - 1);
        for (String possibleOperator : possibleOperators) {
            this.resetActualValueWithIteratorIfRequired(iterator, actualValue, possibleOperator);
            if (!possibleOperator.equals(actualValue.toString())) continue;
            return possibleOperator;
        }
        String op = String.valueOf(operator);
        this.resetActualValueWithIteratorIfRequired(iterator, actualValue, op);
        return op;
    }

    private void resetActualValueWithIteratorIfRequired(StringIterator iterator, StringBuilder actualValue, String possibleOperator) {
        while (possibleOperator.length() < actualValue.length()) {
            actualValue.deleteCharAt(actualValue.length() - 1);
            iterator.previous();
        }
    }

    private int getMaxPossibleOperatorLength(Set<String> possibleOperators) {
        return possibleOperators.iterator().next().length();
    }

    private void fillActualValue(StringBuilder builder, StringIterator iterator, int count) {
        for (int i = 0; i < count && iterator.next(); ++i) {
            builder.append(iterator.getCurrent());
        }
    }

    private void addTokenIfPresent(List<String> tokens, StringBuilder tokenBuilder) {
        if (tokenBuilder.length() > 0) {
            tokens.add(tokenBuilder.toString());
            tokenBuilder.delete(0, tokenBuilder.length());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean resolveVariables(TokenParserRule rule, List<String> tokens, StringIterator iterator, StringBuilder tokenBuilder, char ch) {
        if (rule.areVariablesSupported()) {
            if (!iterator.next()) return true;
            if ('{' == iterator.getCurrent()) {
                this.addTokenIfPresent(tokens, tokenBuilder);
                tokens.add(this.readVariableToken(iterator));
                return false;
            } else {
                tokenBuilder.append(ch);
            }
            return false;
        } else {
            tokenBuilder.append(ch);
        }
        return false;
    }
}

