/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import io.rxmicro.annotation.processor.common.component.SourceCodeFormatter;
import io.rxmicro.annotation.processor.common.component.SourceCodeGenerator;
import io.rxmicro.annotation.processor.common.component.impl.AbstractGenerator;
import io.rxmicro.annotation.processor.common.model.ClassStructure;
import io.rxmicro.annotation.processor.common.model.SourceCode;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

@Singleton
public final class SourceCodeGeneratorImpl
extends AbstractGenerator
implements SourceCodeGenerator {
    @Inject
    private SourceCodeFormatter sourceCodeFormatter;

    @Override
    public SourceCode generate(ClassStructure classStructure) {
        Map<String, Object> variables = classStructure.getTemplateVariables();
        StringWriter stringWriter = new StringWriter();
        try {
            Template template = this.getTemplate(classStructure.getTemplateName());
            template.process(variables, (Writer)stringWriter);
        }
        catch (TemplateException | IOException ex) {
            this.catchThrowable(ex, () -> this.lambda$generate$0(classStructure, (Exception)ex));
        }
        return new SourceCode(classStructure.getTargetFullClassName(), this.sourceCodeFormatter.format(classStructure.getClassHeader(), stringWriter.toString()));
    }

    private /* synthetic */ void lambda$generate$0(ClassStructure classStructure, Exception ex) {
        this.cantGenerateClass(classStructure.getTargetFullClassName(), ex);
    }
}

