/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.component.SourceCodeFormatter;
import io.rxmicro.annotation.processor.common.component.TokenParser;
import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.model.JavaTokenParserRule;
import io.rxmicro.annotation.processor.common.model.TokenParserResult;
import io.rxmicro.annotation.processor.common.model.TokenParserRule;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@Singleton
public final class SourceCodeFormatterImpl
implements SourceCodeFormatter {
    @Inject
    private TokenParser tokenParser;
    @Inject
    @JavaTokenParserRule
    private TokenParserRule javaTokenParserRule;

    @Override
    public String format(ClassHeader classHeader, String content) {
        Set<String> contentTokens = this.getContentTokens(content);
        this.removeUnusedImports(classHeader.getEditableImports().entrySet().iterator(), contentTokens);
        this.removeUnusedImports(classHeader.getEditableStaticImports().entrySet().iterator(), contentTokens);
        String header = classHeader.buildHeader(true);
        String resultContent = header + System.lineSeparator() + content;
        return resultContent.endsWith(System.lineSeparator()) ? resultContent : resultContent + System.lineSeparator();
    }

    private void removeUnusedImports(Iterator<Map.Entry<String, String>> iterator, Set<String> contentTokens) {
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            if (contentTokens.contains(entry.getKey())) continue;
            iterator.remove();
        }
    }

    private Set<String> getContentTokens(String content) {
        HashSet<String> tokens = new HashSet<String>(100);
        StringBuilder stringBuilder = new StringBuilder(120);
        boolean multiLineCommentStarted = false;
        for (int i = 0; i < content.length(); ++i) {
            char ch = content.charAt(i);
            if (ch == '\r') continue;
            if (ch == '\n') {
                TokenParserResult tokenParserResult = this.tokenParser.parse(stringBuilder.toString(), this.javaTokenParserRule, multiLineCommentStarted);
                stringBuilder.delete(0, stringBuilder.length());
                if (tokenParserResult.isNotEmpty()) {
                    tokens.addAll(tokenParserResult.getTokens());
                }
                multiLineCommentStarted = tokenParserResult.isMultiLineCommentStarted();
                continue;
            }
            stringBuilder.append(ch);
        }
        return tokens;
    }
}

