/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.component.PathVariablesResolver;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.common.util.Requires;
import io.rxmicro.documentation.PathVariables;
import javax.lang.model.element.Element;

@Singleton
public final class PathVariablesResolverImpl
implements PathVariablesResolver {
    @Override
    public String resolvePathVariables(Element owner, String projectDirectory, String expression) {
        String result = expression;
        if (result.contains("${USER-DIR}")) {
            result = result.replace("${USER-DIR}", USER_DIR_PATH);
        }
        if (result.contains("${PROJECT-DIR}")) {
            result = result.replace("${PROJECT-DIR}", (CharSequence)Requires.require((Object)projectDirectory));
        }
        if (result.contains("${TEMP-DIR}")) {
            result = result.replace("${TEMP-DIR}", System.getProperty("java.io.tmpdir", "/tmp"));
        }
        if (result.contains("${USER-HOME}")) {
            result = result.replace("${USER-HOME}", System.getProperty("user.home"));
        }
        if (result.contains("$")) {
            throw new InterruptProcessingException(owner, "Expression '?' contains unsupported path variable: ?. Only allowed variables supported: ?", expression, this.getVariableName(result), PathVariables.SUPPORTED_VARIABLES);
        }
        return result;
    }

    private String getVariableName(String expression) {
        int index;
        for (int i = index = expression.indexOf(36); i < expression.length(); ++i) {
            char ch = expression.charAt(i);
            if ("/\\".indexOf(ch) == -1) continue;
            return expression.substring(index, i);
        }
        return expression.substring(index);
    }
}

