/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.component.NumberValidators;
import io.rxmicro.annotation.processor.common.component.impl.BaseProcessorComponent;
import io.rxmicro.annotation.processor.common.model.ModelField;
import io.rxmicro.annotation.processor.common.util.Numbers;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.BigInteger;

@Singleton
public final class NumberValidatorsImpl
extends BaseProcessorComponent
implements NumberValidators {
    private static final String ERROR_MESSAGE_PREFIX = "Annotation '@?' has invalid parameter: ";
    private static final String VALUE_OUT_OF_RANGE_EXPECTED_TEMPLATE = "Value out of range: Expected ? < ? < ?";

    @Override
    public void validateFloat(ModelField modelField, double value, Class<? extends Annotation> annotationClass) {
        if (value < (double)1.4E-45f || value > 3.4028234663852886E38) {
            this.error(modelField.getElementAnnotatedBy(annotationClass), "Annotation '@?' has invalid parameter: Value out of range: Expected ? < ? < ?", annotationClass.getSimpleName(), Float.valueOf(Float.MIN_VALUE), value, Float.valueOf(Float.MAX_VALUE));
        }
    }

    @Override
    public boolean validateFloat(ModelField modelField, String value, Class<? extends Annotation> annotationClass) {
        BigDecimal result = this.toBigDecimalOrNull(modelField, value, annotationClass);
        if (result == null) {
            return false;
        }
        if (result.compareTo(BigDecimal.valueOf(1.4E-45f)) < 0 || result.compareTo(BigDecimal.valueOf(3.4028234663852886E38)) > 0) {
            this.error(modelField.getElementAnnotatedBy(annotationClass), "Annotation '@?' has invalid parameter: Value out of range: Expected ? < ? < ?", annotationClass.getSimpleName(), Float.valueOf(Float.MIN_VALUE), value, Float.valueOf(Float.MAX_VALUE));
            return false;
        }
        return true;
    }

    @Override
    public boolean validateDouble(ModelField modelField, String value, Class<? extends Annotation> annotationClass) {
        BigDecimal result = this.toBigDecimalOrNull(modelField, value, annotationClass);
        if (result == null) {
            return false;
        }
        if (result.compareTo(BigDecimal.valueOf(Double.MIN_VALUE)) < 0 || result.compareTo(BigDecimal.valueOf(Double.MAX_VALUE)) > 0) {
            this.error(modelField.getElementAnnotatedBy(annotationClass), "Annotation '@?' has invalid parameter: Value out of range: Expected ? < ? < ?", annotationClass.getSimpleName(), Double.MIN_VALUE, value, Double.MAX_VALUE);
            return false;
        }
        return true;
    }

    @Override
    public void validateByte(ModelField modelField, long value, Class<? extends Annotation> annotationClass) {
        if (value < -128L || value > 127L) {
            this.error(modelField.getElementAnnotatedBy(annotationClass), "Annotation '@?' has invalid parameter: Value out of range: Expected ? < ? < ?", annotationClass.getSimpleName(), (byte)-128, value, (byte)127);
        }
    }

    @Override
    public boolean validateByte(ModelField modelField, String value, Class<? extends Annotation> annotationClass) {
        BigInteger result = this.toBigIntegerOrNull(modelField, value, annotationClass);
        if (result == null) {
            return false;
        }
        if (result.compareTo(BigInteger.valueOf(-128L)) < 0 || result.compareTo(BigInteger.valueOf(127L)) > 0) {
            this.error(modelField.getElementAnnotatedBy(annotationClass), "Annotation '@?' has invalid parameter: Value out of range: Expected ? < ? < ?", annotationClass.getSimpleName(), (byte)-128, value, (byte)127);
            return false;
        }
        return true;
    }

    @Override
    public void validateShort(ModelField modelField, long value, Class<? extends Annotation> annotationClass) {
        if (value < -32768L || value > 32767L) {
            this.error(modelField.getElementAnnotatedBy(annotationClass), "Annotation '@?' has invalid parameter: Value out of range: Expected ? < ? < ?", annotationClass.getSimpleName(), (short)Short.MIN_VALUE, value, (short)Short.MAX_VALUE);
        }
    }

    @Override
    public boolean validateShort(ModelField modelField, String value, Class<? extends Annotation> annotationClass) {
        BigInteger result = this.toBigIntegerOrNull(modelField, value, annotationClass);
        if (result == null) {
            return false;
        }
        if (result.compareTo(BigInteger.valueOf(-32768L)) < 0 || result.compareTo(BigInteger.valueOf(32767L)) > 0) {
            this.error(modelField.getElementAnnotatedBy(annotationClass), "Annotation '@?' has invalid parameter: Value out of range: Expected ? < ? < ?", annotationClass.getSimpleName(), (short)Short.MIN_VALUE, value, (short)Short.MAX_VALUE);
            return false;
        }
        return true;
    }

    @Override
    public void validateInteger(ModelField modelField, long value, Class<? extends Annotation> annotationClass) {
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            this.error(modelField.getElementAnnotatedBy(annotationClass), "Annotation '@?' has invalid parameter: Value out of range: Expected ? < ? < ?", annotationClass.getSimpleName(), Integer.MIN_VALUE, value, Integer.MAX_VALUE);
        }
    }

    @Override
    public boolean validateInteger(ModelField modelField, String value, Class<? extends Annotation> annotationClass) {
        BigInteger result = this.toBigIntegerOrNull(modelField, value, annotationClass);
        if (result == null) {
            return false;
        }
        if (result.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) < 0 || result.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
            this.error(modelField.getElementAnnotatedBy(annotationClass), "Annotation '@?' has invalid parameter: Value out of range: Expected ? < ? < ?", annotationClass.getSimpleName(), Integer.MIN_VALUE, value, Integer.MAX_VALUE);
            return false;
        }
        return true;
    }

    @Override
    public boolean validateLong(ModelField modelField, String value, Class<? extends Annotation> annotationClass) {
        BigInteger result = this.toBigIntegerOrNull(modelField, value, annotationClass);
        if (result == null) {
            return false;
        }
        if (result.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) < 0 || result.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0) {
            this.error(modelField.getElementAnnotatedBy(annotationClass), "Annotation '@?' has invalid parameter: Value out of range: Expected ? < ? < ?", annotationClass.getSimpleName(), Long.MIN_VALUE, value, Long.MAX_VALUE);
            return false;
        }
        return true;
    }

    @Override
    public boolean validateBigInteger(ModelField modelField, String value, Class<? extends Annotation> annotationClass) {
        return this.toBigIntegerOrNull(modelField, value, annotationClass) != null;
    }

    @Override
    public boolean validateBigDecimal(ModelField modelField, String value, Class<? extends Annotation> annotationClass) {
        return this.toBigDecimalOrNull(modelField, value, annotationClass) != null;
    }

    private BigInteger toBigIntegerOrNull(ModelField modelField, String value, Class<? extends Annotation> annotationClass) {
        try {
            return new BigInteger(Numbers.removeUnderscoresIfPresent(value));
        }
        catch (NumberFormatException ignore) {
            this.error(modelField.getElementAnnotatedBy(annotationClass), "Annotation '@?' has invalid parameter: Expected an integer number", annotationClass.getSimpleName());
            return null;
        }
    }

    private BigDecimal toBigDecimalOrNull(ModelField modelField, String value, Class<? extends Annotation> annotationClass) {
        try {
            return new BigDecimal(Numbers.removeUnderscoresIfPresent(value));
        }
        catch (NumberFormatException ignore) {
            this.error(modelField.getElementAnnotatedBy(annotationClass), "Annotation '@?' has invalid parameter: Expected a number", annotationClass.getSimpleName());
            return null;
        }
    }
}

