/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.component.ModuleInfoDescriptorValidator;
import io.rxmicro.annotation.processor.common.component.impl.BaseProcessorComponent;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.common.util.ProcessingEnvironmentHelper;
import io.rxmicro.common.RxMicroModule;
import io.rxmicro.common.util.Formats;
import io.rxmicro.config.Config;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;

@Singleton
public final class ModuleInfoDescriptorValidatorImpl
extends BaseProcessorComponent
implements ModuleInfoDescriptorValidator {
    @Override
    public void validate(ModuleElement moduleElement) {
        if (this.getBooleanOption("RX_MICRO_STRICT_MODE", false)) {
            this.validateThatDocumentationModuleIsStatic(moduleElement);
        }
        if (moduleElement.isUnnamed()) {
            this.validateDefaultPackage(ProcessingEnvironmentHelper.getElements().getPackageElement(""), true);
        } else {
            this.validateDefaultPackage(ProcessingEnvironmentHelper.getElements().getPackageElement(moduleElement, ""), false);
            this.validateThatCustomConfigPackageIsExportedToReflectionModule(moduleElement);
        }
    }

    private void validateThatDocumentationModuleIsStatic(ModuleElement moduleElement) {
        for (ModuleElement.Directive directive : moduleElement.getDirectives()) {
            if (directive.getKind() != ModuleElement.DirectiveKind.REQUIRES) continue;
            ModuleElement.RequiresDirective requiresDirective = (ModuleElement.RequiresDirective)directive;
            if (!RxMicroModule.RX_MICRO_DOCUMENTATION_ASCIIDOCTOR_MODULE.getName().equals(requiresDirective.getDependency().getQualifiedName().toString()) || requiresDirective.isStatic()) continue;
            throw new InterruptProcessingException("https://docs.rxmicro.io/latest/user-guide/project-documentation.html#min_settings", moduleElement, "'?' module is required for compile time only! Add 'static' modifier and remove dependency from classpath!", RxMicroModule.RX_MICRO_DOCUMENTATION_ASCIIDOCTOR_MODULE.getName());
        }
    }

    private void validateThatCustomConfigPackageIsExportedToReflectionModule(ModuleElement moduleElement) {
        Map<String, List<String>> missingExports;
        Set<PackageElement> packageElements = moduleElement.getEnclosedElements().stream().map(e -> (PackageElement)e).filter(this::hasCustomConfigClass).collect(Collectors.toSet());
        if (!packageElements.isEmpty() && !(missingExports = this.getMissingExports(moduleElement, packageElements)).isEmpty()) {
            throw new InterruptProcessingException("https://docs.rxmicro.io/latest/user-guide/core.html#user_defined_configurations", moduleElement, "For custom config classes it is necessary to add 'exports' directive to the 'module-info.java'. The following export directive(s) is(are) missing: {?}.", missingExports.entrySet().stream().map(e -> Formats.format((String)"exports ? to ?;", (Object[])new Object[]{e.getKey(), String.join((CharSequence)",", (Iterable)e.getValue())})).collect(Collectors.joining(" ")));
        }
    }

    private Map<String, List<String>> getMissingExports(ModuleElement moduleElement, Set<PackageElement> packageElements) {
        LinkedHashMap<String, List<String>> missingExports = new LinkedHashMap<String, List<String>>();
        List<String> requiredExportTargets = List.of(RxMicroModule.RX_MICRO_REFLECTION_MODULE.getName());
        for (ModuleElement.Directive directive : moduleElement.getDirectives()) {
            if (directive.getKind() != ModuleElement.DirectiveKind.EXPORTS) continue;
            ModuleElement.ExportsDirective exportsDirective = (ModuleElement.ExportsDirective)directive;
            Iterator<PackageElement> iterator = packageElements.iterator();
            while (iterator.hasNext()) {
                PackageElement packageElement = iterator.next();
                String packageName = packageElement.getQualifiedName().toString();
                if (!exportsDirective.getPackage().getQualifiedName().toString().equals(packageName)) continue;
                ArrayList<String> exportTargets = new ArrayList<String>(requiredExportTargets);
                for (ModuleElement moduleElement2 : exportsDirective.getTargetModules()) {
                    String targetModuleName = moduleElement2.getQualifiedName().toString();
                    exportTargets.remove(targetModuleName);
                }
                if (!exportTargets.isEmpty()) {
                    missingExports.put(packageName, exportTargets);
                }
                iterator.remove();
            }
            if (!packageElements.isEmpty()) continue;
            return missingExports;
        }
        for (PackageElement packageElement : packageElements) {
            missingExports.put(packageElement.getQualifiedName().toString(), requiredExportTargets);
        }
        return missingExports;
    }

    private boolean hasCustomConfigClass(PackageElement packageElement) {
        for (Element element : packageElement.getEnclosedElements()) {
            if (!(element instanceof TypeElement) || !Elements.findSuperType((TypeElement)element, Config.class).isPresent()) continue;
            return true;
        }
        return false;
    }

    private void validateDefaultPackage(PackageElement packageElement, boolean isUnNamedModule) {
        if (packageElement == null) {
            return;
        }
        for (Element element : packageElement.getEnclosedElements()) {
            if (!(element instanceof TypeElement)) continue;
            if (isUnNamedModule) {
                if ("ModuleInfo".equals(element.getSimpleName().toString())) continue;
                this.error("https://docs.rxmicro.io/latest/user-guide/java-integration.html#java-integration-unnamed-module", element, "Each class (interface, enum or annotation) must be declared at a package! Unnamed (default) package is not supported! Move this element to the named package! FYI: If you want to add the virtual module you should use the predefined by RxMicro framework name: '?' instead of '?'!", "ModuleInfo", element.getSimpleName());
                continue;
            }
            if ("ModuleInfo".equals(element.getSimpleName().toString())) {
                this.error(element, "? is used as alternative of `module-info.java` only! To configure project use `module-info.java` instead of `?.java`", "ModuleInfo", "ModuleInfo");
                continue;
            }
            this.error(element, "Each class (interface, enum or annotation) must be declared at a package! Unnamed (default) package is not supported! Move this element to the named package!", new Object[0]);
        }
    }
}

