/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.component.MethodResultBuilder;
import io.rxmicro.annotation.processor.common.component.impl.BaseProcessorComponent;
import io.rxmicro.annotation.processor.common.component.impl.ReactiveMethodResultBuilder;
import io.rxmicro.annotation.processor.common.model.definition.SupportedTypesProvider;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.model.method.MethodResult;
import io.rxmicro.annotation.processor.common.util.ProcessingEnvironmentHelper;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;

@Singleton
public final class MethodResultBuilderImpl
extends BaseProcessorComponent
implements MethodResultBuilder {
    @Inject
    private Set<ReactiveMethodResultBuilder> reactiveMethodResultBuilders;

    @Override
    public MethodResult build(ExecutableElement method, SupportedTypesProvider supportedTypesProvider) {
        return this.reactiveMethodResultBuilders.stream().filter(builder -> builder.isSupport(method) && supportedTypesProvider.getReactiveReturnTypes().contains(ProcessingEnvironmentHelper.getTypes().erasure(method.getReturnType()))).map(builder -> builder.build(method, supportedTypesProvider)).findFirst().orElseThrow(() -> {
            throw new InterruptProcessingException(method, "Invalid return type. Expected one of the following: ?", supportedTypesProvider.getReactiveReturnTypes().getTypeDefinitions());
        });
    }
}

