/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.component.MethodParametersBuilder;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.common.model.ModelFieldBuilderOptions;
import io.rxmicro.annotation.processor.common.model.definition.SupportedTypesProvider;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.model.method.MethodParameter;
import io.rxmicro.annotation.processor.common.util.ModelTypeElements;
import io.rxmicro.annotation.processor.common.util.validators.TypeValidators;
import io.rxmicro.common.util.Formats;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

@Singleton
public final class MethodParametersBuilderImpl
implements MethodParametersBuilder {
    @Override
    public List<MethodParameter> build(EnvironmentContext environmentContext, ExecutableElement repositoryMethod, SupportedTypesProvider typesProvider) {
        return repositoryMethod.getParameters().stream().peek(parameter -> this.validateParameter(environmentContext, repositoryMethod, (VariableElement)parameter, typesProvider)).map(parameter -> new MethodParameter(repositoryMethod, (VariableElement)parameter)).collect(Collectors.toList());
    }

    private void validateParameter(EnvironmentContext environmentContext, ExecutableElement repositoryMethod, VariableElement parameter, SupportedTypesProvider typesProvider) {
        TypeMirror type = parameter.asType();
        if (typesProvider.getNotEntityMethodParameters().contains(type) || type.getKind().isPrimitive()) {
            return;
        }
        if (typesProvider.getCollectionContainers().contains(type)) {
            TypeValidators.validateGenericType(repositoryMethod, type, Formats.format((String)"Method parameter type '?' not supported", (Object[])new Object[]{type}));
        } else {
            try {
                ModuleElement currentModule = environmentContext.getCurrentModule();
                ModelTypeElements.asValidatedModelTypeElement(currentModule, repositoryMethod, type, "Invalid method parameter", ModelFieldBuilderOptions.DEFAULT_OPTIONS);
            }
            catch (InterruptProcessingException ex) {
                throw new InterruptProcessingException(repositoryMethod, "Method parameter type '?' not supported: ?.Use a model class or one of the following types: ?", type, ex.getMessage(), typesProvider.getNotEntityMethodParameters().getTypeDefinitions());
            }
        }
    }
}

