/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.component.ExpressionBuilder;
import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.model.Expression;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.common.util.Formats;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

@Singleton
public final class ExpressionBuilderImpl
implements ExpressionBuilder {
    @Override
    public String build(ClassHeader.Builder classHeaderBuilder, Expression expression, TypeElement configClass, String modelVariableName) {
        if ("?".equals(expression.getTemplate())) {
            VariableElement configField = expression.getConfigFields().get(0);
            return Formats.format((String)"?.?()", (Object[])new Object[]{modelVariableName, this.getGetterName(configClass, configField)});
        }
        classHeaderBuilder.addStaticImport(Formats.class, "format");
        return Formats.format((String)"format(\"?\", ?)", (Object[])new Object[]{expression.getTemplate(), this.buildArguments(expression, configClass, modelVariableName)});
    }

    private Object buildArguments(Expression expression, TypeElement configClass, String modelVariableName) {
        return expression.getConfigFields().stream().map(v -> Formats.format((String)"?.?()", (Object[])new Object[]{modelVariableName, this.getGetterName(configClass, (VariableElement)v)})).collect(Collectors.joining(", "));
    }

    private String getGetterName(TypeElement configClass, VariableElement var) {
        List<ExecutableElement> getters = Elements.findGetters(configClass, var);
        if (getters.isEmpty()) {
            throw new InterruptProcessingException(configClass, "Missing a getter. Add a getter for '?.?' field", configClass.getQualifiedName(), var.getSimpleName());
        }
        return getters.get(0).getSimpleName().toString();
    }
}

