/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.component.CurrentModuleDecorator;
import io.rxmicro.annotation.processor.common.component.EnvironmentContextBuilder;
import io.rxmicro.annotation.processor.common.component.ModuleInfoDescriptorValidator;
import io.rxmicro.annotation.processor.common.component.impl.BaseProcessorComponent;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Annotations;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.common.util.ProcessingEnvironmentHelper;
import io.rxmicro.common.ImpossibleException;
import io.rxmicro.common.RxMicroModule;
import io.rxmicro.config.ExcludeAll;
import io.rxmicro.config.IncludeAll;
import io.rxmicro.model.BaseModel;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;

@Singleton
public final class EnvironmentContextBuilderImpl
extends BaseProcessorComponent
implements EnvironmentContextBuilder {
    @Inject
    private CurrentModuleDecorator currentModuleDecorator;
    @Inject
    private ModuleInfoDescriptorValidator moduleInfoDescriptorValidator;

    @Override
    public EnvironmentContext build(RoundEnvironment roundEnv, ModuleElement realModuleElement) {
        this.moduleInfoDescriptorValidator.validate(realModuleElement);
        ModuleElement currentModule = this.currentModuleDecorator.decorate(realModuleElement);
        Set<RxMicroModule> rxMicroModules = this.getRxMicroModules(currentModule);
        Map<String, Element> includePackages = roundEnv.getElementsAnnotatedWith(IncludeAll.class).stream().map(el -> Map.entry(((QualifiedNameable)el).getQualifiedName().toString(), el)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<String, Element> excludePackages = roundEnv.getElementsAnnotatedWith(ExcludeAll.class).stream().map(el -> Map.entry(((QualifiedNameable)el).getQualifiedName().toString(), el)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.validate(includePackages, excludePackages);
        EnvironmentContext environmentContext = new EnvironmentContext(currentModule, rxMicroModules, Set.copyOf(includePackages.keySet()), Set.copyOf(excludePackages.keySet()), Annotations.getValidatedDefaultConfigValues(currentModule), this.getPackagesThatMustBeOpenedToRxMicroReflectionModule(currentModule));
        this.info("?", environmentContext);
        return environmentContext;
    }

    private Set<RxMicroModule> getRxMicroModules(ModuleElement currentModule) {
        if (currentModule.isUnnamed()) {
            return Arrays.stream(RxMicroModule.values()).filter(m -> ProcessingEnvironmentHelper.getElements().getPackageElement(m.getRootPackage()) != null).collect(Collectors.toSet());
        }
        return ProcessingEnvironmentHelper.getElements().getAllModuleElements().stream().flatMap(me -> RxMicroModule.of((String)me.getQualifiedName().toString()).stream()).collect(Collectors.toSet());
    }

    private void validate(Map<String, Element> includePackages, Map<String, Element> excludePackages) {
        for (Map.Entry<String, Element> entry : includePackages.entrySet()) {
            if (!excludePackages.containsKey(entry.getKey())) continue;
            throw new InterruptProcessingException(entry.getValue(), "? '?' both included and excluded", entry.getValue() instanceof PackageElement ? "Package" : "Class or interface", entry.getKey());
        }
    }

    private List<String> getPackagesThatMustBeOpenedToRxMicroReflectionModule(ModuleElement currentModule) {
        if (currentModule.isUnnamed()) {
            return List.of();
        }
        List<String> packages = this.getPackagesThatContainModelClassesWithDynamicToStringMethod(currentModule);
        if (packages.isEmpty()) {
            return List.of();
        }
        List alreadyOpenedPackages = currentModule.getDirectives().stream().filter(d -> d.getKind() == ModuleElement.DirectiveKind.OPENS).map(d -> (ModuleElement.OpensDirective)d).filter(d -> d.getTargetModules().stream().anyMatch(moduleElement -> RxMicroModule.RX_MICRO_REFLECTION_MODULE.getName().equals(moduleElement.getQualifiedName().toString()))).map(d -> d.getPackage().getQualifiedName().toString()).collect(Collectors.toList());
        return packages.stream().filter(packageName -> alreadyOpenedPackages.stream().noneMatch(alreadyOpenedPackage -> alreadyOpenedPackage.equals(packageName))).sorted().collect(Collectors.toList());
    }

    private List<String> getPackagesThatContainModelClassesWithDynamicToStringMethod(ModuleElement currentModule) {
        return currentModule.getEnclosedElements().stream().flatMap(e -> e.getEnclosedElements().stream()).filter(e -> e.getKind() == ElementKind.CLASS && Elements.doesExtendSuperType((TypeElement)e, BaseModel.class) && this.doesToStringMethodNotOverridden((TypeElement)e)).map(e -> ((PackageElement)e.getEnclosingElement()).getQualifiedName().toString()).collect(Collectors.toList());
    }

    private boolean doesToStringMethodNotOverridden(TypeElement typeElement) {
        TypeElement current = typeElement;
        while (!BaseModel.class.getName().equals(current.getQualifiedName().toString())) {
            if (current.getEnclosedElements().stream().anyMatch(e -> e.getKind() == ElementKind.METHOD && "toString".equals(e.getSimpleName().toString()) && ((ExecutableElement)e).getParameters().isEmpty())) {
                return false;
            }
            current = Elements.asTypeElement(current.getSuperclass()).orElseThrow(() -> {
                throw new ImpossibleException("Type element extends the BaseModel class, so super class must be found always!", new Object[0]);
            });
        }
        return true;
    }
}

