/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import io.rxmicro.annotation.processor.common.component.DocumentationGenerator;
import io.rxmicro.annotation.processor.common.component.PathVariablesResolver;
import io.rxmicro.annotation.processor.common.component.impl.AbstractGenerator;
import io.rxmicro.annotation.processor.common.model.DocumentStructure;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;

@Singleton
public final class DocumentationGeneratorImpl
extends AbstractGenerator
implements DocumentationGenerator {
    @Inject
    private PathVariablesResolver pathVariablesResolver;

    @Override
    public void generate(DocumentStructure documentStructure) {
        Map<String, Object> variables = documentStructure.getTemplateVariables();
        try {
            StringWriter stringWriter;
            String destinationFile = this.getDestinationFile(documentStructure);
            try (StringWriter writer = stringWriter = new StringWriter();){
                Template template = this.getTemplate(documentStructure.getTemplateName());
                template.process(variables, (Writer)writer);
            }
            Files.writeString(Paths.get(destinationFile, new String[0]), (CharSequence)stringWriter.toString(), new OpenOption[0]);
            this.info("Document generated successfully: ?", destinationFile);
        }
        catch (TemplateException | IOException ex) {
            this.catchThrowable(ex, () -> this.lambda$generate$0(documentStructure, (Exception)ex));
        }
    }

    private String getDestinationFile(DocumentStructure documentStructure) throws IOException {
        String dir = this.getDirectory(documentStructure);
        Path path = Paths.get(dir, new String[0]).toAbsolutePath();
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException ex) {
                throw new IOException("Can't created directory: " + path, ex);
            }
        }
        if (dir.endsWith("/")) {
            return dir + documentStructure.getName();
        }
        return dir + "/" + documentStructure.getName();
    }

    private String getDirectory(DocumentStructure documentStructure) {
        return this.pathVariablesResolver.resolvePathVariables(documentStructure.getCurrentModule(), documentStructure.getProjectDirectory(), documentStructure.getCustomDestinationDirectory().orElseGet(() -> this.getStringOption("RX_MICRO_DOC_DESTINATION_DIR", documentStructure.getDocumentationType().getDestinationDirectory())));
    }

    private /* synthetic */ void lambda$generate$0(DocumentStructure documentStructure, Exception ex) {
        this.cantGenerateDocument(documentStructure.getName(), ex);
    }
}

