/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.component.CurrentModuleDecorator;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.model.virtual.VirtualModuleElement;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.common.util.ProcessingEnvironmentHelper;
import io.rxmicro.annotation.processor.common.util.validators.AnnotationValidators;
import io.rxmicro.annotation.processor.common.util.validators.FieldValidators;
import io.rxmicro.annotation.processor.common.util.validators.TypeValidators;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

@Singleton
public final class CurrentModuleDecoratorImpl
implements CurrentModuleDecorator {
    @Override
    public ModuleElement decorate(ModuleElement currentModuleElement) {
        if (currentModuleElement.isUnnamed()) {
            TypeElement moduleInfo = ProcessingEnvironmentHelper.getElements().getTypeElement("ModuleInfo");
            if (moduleInfo != null) {
                this.validateAnnotation(moduleInfo);
                Map<String, VariableElement> parameters = this.extractParameters(moduleInfo);
                String moduleName = Optional.ofNullable(parameters.get("NAME")).map(v -> (String)v.getConstantValue()).orElse("virtual.module");
                return new VirtualModuleElement(currentModuleElement, moduleInfo, moduleName);
            }
            return currentModuleElement;
        }
        return currentModuleElement;
    }

    private Map<String, VariableElement> extractParameters(TypeElement moduleInfo) {
        HashMap<String, VariableElement> map = new HashMap<String, VariableElement>();
        for (VariableElement field : Elements.allFields(moduleInfo, v -> true)) {
            if ("NAME".equals(field.getSimpleName().toString())) {
                this.validateName(field);
                map.put("NAME", field);
                continue;
            }
            throw new InterruptProcessingException(moduleInfo, "Unsupported field for virtual module info annotation: '?'. The following fields are supported only: ?", field.getSimpleName(), List.of("NAME"));
        }
        return map;
    }

    private void validateAnnotation(TypeElement moduleInfo) {
        TypeValidators.validateExpectedElementKind(moduleInfo, ElementKind.ANNOTATION_TYPE, "The '?' must be an annotation!", "ModuleInfo");
        AnnotationValidators.validateCustomAnnotation(moduleInfo, Set.of());
    }

    private void validateName(VariableElement field) {
        FieldValidators.validateExpectedFieldType(field, String.class);
    }
}

