/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.component.impl;

import com.google.inject.Module;
import io.rxmicro.annotation.processor.common.FormatSourceCodeDependenciesModule;
import io.rxmicro.annotation.processor.common.component.impl.AbstractModuleClassStructuresBuilder;
import io.rxmicro.annotation.processor.common.model.ClassStructure;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.common.model.error.InternalErrorException;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingBecauseAFewErrorsFoundException;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Injects;
import io.rxmicro.annotation.processor.common.util.LoggerMessages;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;

public class CompositeModuleClassStructuresBuilder<T extends AbstractModuleClassStructuresBuilder>
extends AbstractModuleClassStructuresBuilder {
    private final List<T> moduleClassStructuresBuilders;

    public CompositeModuleClassStructuresBuilder(List<T> moduleClassStructuresBuilders) {
        this.validate(moduleClassStructuresBuilders);
        this.moduleClassStructuresBuilders = moduleClassStructuresBuilders;
        Injects.injectDependencies(this, new Module[]{new FormatSourceCodeDependenciesModule()});
    }

    private void validate(List<T> moduleClassStructuresBuilders) {
        HashSet<String> supportedAnnotationTypes = new HashSet<String>();
        for (AbstractModuleClassStructuresBuilder builder : moduleClassStructuresBuilders) {
            for (String annotationType : builder.getSupportedAnnotationTypes()) {
                if (supportedAnnotationTypes.add(annotationType)) continue;
                throw new InternalErrorException("Detected duplicate of ?, which supported '@?' annotation", builder.getClass(), annotationType);
            }
        }
        if (moduleClassStructuresBuilders.isEmpty()) {
            throw new InternalErrorException("moduleClassStructuresBuilders is empty", new Object[0]);
        }
    }

    @Override
    public String getBuilderName() {
        return "composite-annotation-processor-module";
    }

    @Override
    public final Set<String> getSupportedAnnotationTypes() {
        return this.moduleClassStructuresBuilders.stream().flatMap(builder -> builder.getSupportedAnnotationTypes().stream()).collect(Collectors.toSet());
    }

    @Override
    public Set<? extends ClassStructure> buildClassStructures(EnvironmentContext environmentContext, Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            HashSet<ClassStructure> classStructures = new HashSet<ClassStructure>();
            HashMap<AbstractModuleClassStructuresBuilder, Set> map = new HashMap<AbstractModuleClassStructuresBuilder, Set>();
            for (TypeElement typeElement : annotations) {
                for (AbstractModuleClassStructuresBuilder builder2 : this.moduleClassStructuresBuilders) {
                    if (!builder2.getSupportedAnnotationTypes().contains(typeElement.asType().toString())) continue;
                    Set set = map.computeIfAbsent(builder2, b -> new HashSet());
                    set.add(typeElement);
                }
            }
            for (Map.Entry entry : map.entrySet()) {
                AbstractModuleClassStructuresBuilder builder3 = (AbstractModuleClassStructuresBuilder)entry.getKey();
                Set typeElements = (Set)entry.getValue();
                this.addClassStructuresUsingProvidedBuilder(environmentContext, roundEnv, classStructures, builder3, typeElements);
            }
            this.moduleClassStructuresBuilders.forEach(builder -> builder.afterAllClassStructuresBuilt(classStructures));
            return classStructures;
        }
        catch (InterruptProcessingException ex) {
            this.error(ex);
            return Set.of();
        }
        catch (InterruptProcessingBecauseAFewErrorsFoundException ignore) {
            return Set.of();
        }
    }

    private void addClassStructuresUsingProvidedBuilder(EnvironmentContext environmentContext, RoundEnvironment roundEnv, Set<ClassStructure> classStructures, T builder, Set<TypeElement> typeElements) {
        try {
            if (!(builder instanceof CompositeModuleClassStructuresBuilder)) {
                this.debug("------------------------------------------------------------------------", new Supplier[0]);
                this.debug(() -> LoggerMessages.getAlignedWithLineDelimiterMessage("? started", builder.getBuilderName()));
                this.debug("------------------------------------------------------------------------", new Supplier[0]);
            }
            classStructures.addAll(((AbstractModuleClassStructuresBuilder)builder).buildClassStructures(environmentContext, typeElements, roundEnv));
            if (!(builder instanceof CompositeModuleClassStructuresBuilder)) {
                this.debug("------------------------------------------------------------------------", new Supplier[0]);
                this.debug(() -> LoggerMessages.getAlignedWithLineDelimiterMessage("? completed", builder.getBuilderName()));
                this.debug("------------------------------------------------------------------------", new Supplier[0]);
            }
        }
        catch (InterruptProcessingException ex) {
            this.error(ex);
        }
        catch (InterruptProcessingBecauseAFewErrorsFoundException interruptProcessingBecauseAFewErrorsFoundException) {
            // empty catch block
        }
    }
}

