/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.component.ClassWriter;
import io.rxmicro.annotation.processor.common.component.impl.BaseProcessorComponent;
import io.rxmicro.annotation.processor.common.model.AnnotationProcessorType;
import io.rxmicro.annotation.processor.common.model.SourceCode;
import io.rxmicro.annotation.processor.common.util.ProcessingEnvironmentHelper;
import java.io.IOException;
import java.io.Writer;
import java.util.function.Supplier;
import javax.annotation.processing.FilerException;
import javax.lang.model.element.Element;

@Singleton
public final class ClassWriterImpl
extends BaseProcessorComponent
implements ClassWriter {
    @Override
    public void write(SourceCode sourceCode, AnnotationProcessorType annotationProcessorType) {
        try (Writer writer = ProcessingEnvironmentHelper.getFiler().createSourceFile(sourceCode.getName(), new Element[0]).openWriter();){
            writer.write(sourceCode.getContent());
            if (annotationProcessorType == AnnotationProcessorType.PROJECT_COMPILE) {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = sourceCode::getName;
                this.debug("Class generated successfully: ?", supplierArray);
            } else {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = sourceCode::getName;
                this.info("Test fixer class generated successfully: ?", supplierArray);
            }
        }
        catch (FilerException ex) {
            if (!ex.getMessage().startsWith("Attempt to recreate a file for type ")) {
                this.cantGenerateClass(sourceCode.getName(), ex);
            }
        }
        catch (IOException ex) {
            this.cantGenerateClass(sourceCode.getName(), ex);
        }
    }
}

