/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.component.impl;

import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.InternalLoggers;
import io.rxmicro.annotation.processor.common.util.ProcessingEnvironmentHelper;
import io.rxmicro.annotation.processor.config.LogLevel;
import io.rxmicro.annotation.processor.config.SupportedOptions;
import io.rxmicro.common.util.Formats;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;

public class BaseProcessorComponent {
    private LogLevel level;

    protected BaseProcessorComponent() {
    }

    private LogLevel getLevel() {
        if (this.level == null) {
            String stringLogLevel = this.getStringOption("RX_MICRO_LOG_LEVEL", SupportedOptions.RX_MICRO_LOG_LEVEL_DEFAULT_VALUE.name());
            try {
                this.level = LogLevel.valueOf((String)stringLogLevel);
            }
            catch (IllegalArgumentException ignore) {
                ProcessingEnvironmentHelper.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, Formats.format((String)"Unsupported logger level for the RxMicro Annotation Processor: '?'. Only following supported: ?. Using default level: '?'", (Object[])new Object[]{stringLogLevel, Arrays.toString(LogLevel.values()), SupportedOptions.RX_MICRO_LOG_LEVEL_DEFAULT_VALUE}));
                this.level = SupportedOptions.RX_MICRO_LOG_LEVEL_DEFAULT_VALUE;
            }
        }
        return this.level;
    }

    protected final boolean isTraceEnabled() {
        return this.getLevel().isEnabled(LogLevel.TRACE);
    }

    protected final void trace(Supplier<String> supplier) {
        if (this.isTraceEnabled()) {
            InternalLoggers.logMessage(LogLevel.TRACE, supplier.get());
        }
    }

    protected final void trace(String message, Object ... args) {
        if (this.isTraceEnabled()) {
            InternalLoggers.logMessage(LogLevel.TRACE, Formats.format((String)message, (Object[])args));
        }
    }

    protected final void trace(String message, Supplier<?> ... args) {
        if (this.isTraceEnabled()) {
            InternalLoggers.logMessage(LogLevel.TRACE, Formats.format((String)message, (Object[])Arrays.stream(args).map(Supplier::get).toArray()));
        }
    }

    protected final boolean isDebugEnabled() {
        return this.getLevel().isEnabled(LogLevel.DEBUG);
    }

    protected final void debug(Supplier<String> supplier) {
        if (this.isDebugEnabled()) {
            InternalLoggers.logMessage(LogLevel.DEBUG, supplier.get());
        }
    }

    protected final void debug(String message, Object ... args) {
        if (this.isDebugEnabled()) {
            InternalLoggers.logMessage(LogLevel.DEBUG, Formats.format((String)message, (Object[])args));
        }
    }

    protected final void debug(String message, Supplier<?> ... args) {
        if (this.isDebugEnabled()) {
            InternalLoggers.logMessage(LogLevel.DEBUG, Formats.format((String)message, (Object[])Arrays.stream(args).map(Supplier::get).toArray()));
        }
    }

    protected final boolean isInfoEnabled() {
        return this.getLevel().isEnabled(LogLevel.INFO);
    }

    protected final void info(Supplier<String> supplier) {
        if (this.isInfoEnabled()) {
            InternalLoggers.logMessage(LogLevel.INFO, supplier.get());
        }
    }

    protected final void info(String message, Object ... args) {
        if (this.isInfoEnabled()) {
            InternalLoggers.logMessage(LogLevel.INFO, Formats.format((String)message, (Object[])args));
        }
    }

    protected final void info(String message, Supplier<?> ... args) {
        if (this.isInfoEnabled()) {
            InternalLoggers.logMessage(LogLevel.INFO, Formats.format((String)message, (Object[])Arrays.stream(args).map(Supplier::get).toArray()));
        }
    }

    protected final void warn(String readMoreLink, Element element, String message, Object ... args) {
        String mes = Formats.format((String)message, (Object[])args) + Formats.format((String)" Read more at ?", (Object[])new Object[]{readMoreLink});
        ProcessingEnvironmentHelper.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, mes, element);
    }

    protected final void warn(Element element, String message, Object ... args) {
        String mes = args.length == 0 ? message : Formats.format((String)message, (Object[])args);
        ProcessingEnvironmentHelper.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, mes, element);
    }

    protected final void error(String message, Object ... args) {
        ProcessingEnvironmentHelper.getMessager().printMessage(Diagnostic.Kind.ERROR, Formats.format((String)message, (Object[])args));
    }

    protected final void error(InterruptProcessingException exception) {
        this.error(exception.getElement(), exception.getMessage(), new Object[0]);
    }

    protected final void error(String readMoreLink, Element element, String message, Object ... args) {
        String mes = Formats.format((String)message, (Object[])args) + Formats.format((String)" Read more at ?", (Object[])new Object[]{readMoreLink});
        ProcessingEnvironmentHelper.getMessager().printMessage(Diagnostic.Kind.ERROR, mes, element);
        ProcessingEnvironmentHelper.aNewCompilationErrorDetected();
    }

    protected final void error(Element element, String message, Object ... args) {
        String mes = args.length == 0 ? message : Formats.format((String)message, (Object[])args);
        ProcessingEnvironmentHelper.getMessager().printMessage(Diagnostic.Kind.ERROR, mes, element);
        ProcessingEnvironmentHelper.aNewCompilationErrorDetected();
    }

    protected final void cantGenerateClass(String generatedClassName, Throwable throwable) {
        InternalLoggers.logThrowableStackTrace(throwable);
        ProcessingEnvironmentHelper.getMessager().printMessage(Diagnostic.Kind.ERROR, Formats.format((String)"Can't generate class ?: ?", (Object[])new Object[]{generatedClassName, throwable.getMessage()}));
        ProcessingEnvironmentHelper.aNewCompilationErrorDetected();
    }

    protected final void cantGenerateDocument(String documentName, Throwable throwable) {
        InternalLoggers.logThrowableStackTrace(throwable);
        ProcessingEnvironmentHelper.getMessager().printMessage(Diagnostic.Kind.ERROR, Formats.format((String)"Can't generate document ?: ?", (Object[])new Object[]{documentName, throwable.getMessage()}));
        ProcessingEnvironmentHelper.aNewCompilationErrorDetected();
    }

    protected final void cantGenerateMethodBody(String templateName, Throwable throwable) {
        InternalLoggers.logThrowableStackTrace(throwable);
        ProcessingEnvironmentHelper.getMessager().printMessage(Diagnostic.Kind.ERROR, Formats.format((String)"Can't generate method body using '?' template: ?", (Object[])new Object[]{templateName, throwable.getMessage()}));
        ProcessingEnvironmentHelper.aNewCompilationErrorDetected();
    }

    protected final int getIntOption(String propertyName, int defaultValue) {
        String value = this.getStringOption(propertyName, null);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    protected final boolean getBooleanOption(String propertyName, boolean defaultValue) {
        String value = this.getStringOption(propertyName, null);
        return Optional.ofNullable(value).map(Boolean::parseBoolean).orElse(defaultValue);
    }

    protected final String getStringOption(String propertyName, String defaultValue) {
        String value = ProcessingEnvironmentHelper.getCompilerOptions().get(propertyName);
        if (value != null) {
            return value;
        }
        value = System.getProperty(propertyName);
        if (value != null) {
            return value;
        }
        value = System.getenv().get(propertyName);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }
}

