/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.component.impl;

import com.google.inject.Inject;
import com.google.inject.Module;
import io.rxmicro.annotation.processor.common.component.AnnotationProcessingInformer;
import io.rxmicro.annotation.processor.common.component.ClassWriter;
import io.rxmicro.annotation.processor.common.component.EnvironmentContextBuilder;
import io.rxmicro.annotation.processor.common.component.impl.RxMicroAnnotationProcessorDependenciesModule;
import io.rxmicro.annotation.processor.common.model.AnnotationProcessorType;
import io.rxmicro.annotation.processor.common.model.SourceCode;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingBecauseAFewErrorsFoundException;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Injects;
import io.rxmicro.annotation.processor.common.util.InternalLoggers;
import io.rxmicro.annotation.processor.common.util.ProcessingEnvironmentHelper;
import io.rxmicro.annotation.processor.config.SupportedOptions;
import java.util.Collection;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

public abstract class AbstractRxMicroProcessor
extends AbstractProcessor {
    @Inject
    private EnvironmentContextBuilder environmentContextBuilder;
    @Inject
    private ClassWriter classWriter;
    @Inject
    private AnnotationProcessingInformer annotationProcessingInformer;

    public AbstractRxMicroProcessor() {
        Injects.injectDependencies(this, this.getDependenciesModules().toArray(new Module[0]));
    }

    protected Set<Module> getDependenciesModules() {
        return Set.of(new RxMicroAnnotationProcessorDependenciesModule());
    }

    @Override
    public Set<String> getSupportedOptions() {
        return SupportedOptions.ALL_SUPPORTED_OPTIONS;
    }

    @Override
    public final SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_11;
    }

    @Override
    public final synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        ProcessingEnvironmentHelper.init(processingEnv);
    }

    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (annotations.isEmpty()) {
            return false;
        }
        try {
            this.annotationProcessingInformer.annotationProcessingStarted(this.getAnnotationProcessorType());
            return this.process(this.environmentContextBuilder, annotations, roundEnv);
        }
        catch (InterruptProcessingException ex) {
            ProcessingEnvironmentHelper.getMessager().printMessage(Diagnostic.Kind.ERROR, ex.getMessage(), ex.getElement());
            return false;
        }
        catch (InterruptProcessingBecauseAFewErrorsFoundException ignore) {
            return false;
        }
        catch (Throwable throwable) {
            ProcessingEnvironmentHelper.getMessager().printMessage(Diagnostic.Kind.ERROR, "RxMicroAnnotationProcessor internal error: " + throwable.getMessage());
            InternalLoggers.logThrowableStackTrace(throwable);
            return false;
        }
    }

    protected abstract boolean process(EnvironmentContextBuilder var1, Set<? extends TypeElement> var2, RoundEnvironment var3);

    protected abstract AnnotationProcessorType getAnnotationProcessorType();

    protected final void generateClasses(Collection<SourceCode> sourceCodes) {
        if (ProcessingEnvironmentHelper.doesNotContainCompilationErrors()) {
            this.annotationProcessingInformer.classesGenerationStarted();
            sourceCodes.forEach(sourceCode -> this.classWriter.write((SourceCode)sourceCode, this.getAnnotationProcessorType()));
            this.annotationProcessingInformer.classesGenerationCompleted();
        }
        this.annotationProcessingInformer.annotationProcessingCompleted(this.getAnnotationProcessorType(), ProcessingEnvironmentHelper.doesNotContainCompilationErrors());
    }
}

