/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.component.impl;

import io.rxmicro.annotation.processor.common.component.impl.BaseProcessorComponent;
import io.rxmicro.annotation.processor.common.model.error.InternalErrorException;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Annotations;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.common.util.Names;
import io.rxmicro.annotation.processor.common.util.ProcessingEnvironmentHelper;
import io.rxmicro.annotation.processor.common.util.validators.TypeValidators;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public abstract class AbstractPartialImplementationBuilder
extends BaseProcessorComponent {
    protected final void validateInterfaceType(Element element, Class<? extends Annotation> markerAnnotationType, String name) {
        TypeValidators.validateExpectedElementKind(element, ElementKind.INTERFACE, "'@?' annotation is applied to interface only.", markerAnnotationType.getName());
        TypeValidators.validateNotNestedClass((TypeElement)element, "? interface couldn't be a nested interface.", name);
        TypeValidators.validateNotSuperInterfaces((TypeElement)element, "? interface couldn't extend any interfaces", name);
        TypeValidators.validateThatElementIsPublic(element, "? interface must be a public.", name);
    }

    protected final void validatePartialImplementation(TypeElement interfaceType, TypeElement abstractClassType, Class<? extends Annotation> partialImplementationAnnotation) {
        this.validateThatAbstractClassImplementsInterface(interfaceType, abstractClassType);
        this.validateThatPartialImplementationClassIsAbstract(interfaceType, abstractClassType);
        this.validateThatCorrectVersionOfPartialImplementationUsed(interfaceType, partialImplementationAnnotation);
    }

    private void validateThatAbstractClassImplementsInterface(TypeElement interfaceType, TypeElement abstractClassType) {
        TypeElement currentTypeElement = abstractClassType;
        while (true) {
            for (TypeMirror typeMirror : currentTypeElement.getInterfaces()) {
                if (!typeMirror.toString().equals(interfaceType.asType().toString())) continue;
                return;
            }
            TypeMirror superClass = currentTypeElement.getSuperclass();
            if (Elements.superClassIsObject(superClass)) {
                throw new InterruptProcessingException(interfaceType, "Partial implementation class '?' must implement '?' interface", abstractClassType.asType().toString(), interfaceType.asType().toString());
            }
            currentTypeElement = Elements.asTypeElement(superClass).orElseThrow();
        }
    }

    private void validateThatPartialImplementationClassIsAbstract(TypeElement interfaceType, TypeElement abstractClassType) {
        if (!abstractClassType.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            throw new InterruptProcessingException(interfaceType, "Partial implementation class '?' must be an abstract class", abstractClassType.asType().toString());
        }
    }

    private void validateThatCorrectVersionOfPartialImplementationUsed(TypeElement interfaceType, Class<? extends Annotation> partialImplementationAnnotation) {
        for (AnnotationMirror annotationMirror : interfaceType.getAnnotationMirrors()) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            if (annotationType.toString().equals(partialImplementationAnnotation.getName()) || !"PartialImplementation".equals(Names.getSimpleName(annotationType))) continue;
            throw new InterruptProcessingException(interfaceType, "Annotation '@?' is not valid! Use '@?' instead", annotationType.toString(), partialImplementationAnnotation.getName());
        }
    }

    protected final Map.Entry<TypeElement, List<ExecutableElement>> getOverriddenMethodCandidates(TypeElement restClientInterface) {
        Class<? extends Annotation> partialImplementationAnnotationClass = this.getPartialImplementationAnnotationClass();
        TypeElement defaultAbstractClass = ProcessingEnvironmentHelper.getElements().getTypeElement(this.getDefaultAbstractClass().getName());
        return restClientInterface.getAnnotationMirrors().stream().filter(a -> a.getAnnotationType().toString().equals(partialImplementationAnnotationClass.getName())).findFirst().flatMap(a -> Elements.asTypeElement((TypeMirror)Annotations.getAnnotationValue(a.getElementValues())).map(t -> {
            this.validatePartialImplementation(restClientInterface, (TypeElement)t, partialImplementationAnnotationClass);
            return Map.entry(t, this.getAllOverrideMethodCandidatesExceptBaseMethods(defaultAbstractClass, (TypeElement)t));
        })).orElse(Map.entry(defaultAbstractClass, List.of()));
    }

    protected abstract Class<? extends Annotation> getPartialImplementationAnnotationClass();

    protected abstract Class<?> getDefaultAbstractClass();

    private List<ExecutableElement> getAllOverrideMethodCandidatesExceptBaseMethods(TypeElement baseParentClass, TypeElement abstractClassType) {
        ArrayList<ExecutableElement> methods = new ArrayList<ExecutableElement>();
        TypeElement currentTypeElement = abstractClassType;
        while (true) {
            methods.addAll(0, currentTypeElement.getEnclosedElements().stream().filter(el -> el.getKind() == ElementKind.METHOD).map(el -> (ExecutableElement)el).filter(el -> Set.of(Modifier.PRIVATE, Modifier.STATIC).stream().noneMatch(m -> el.getModifiers().contains(m))).collect(Collectors.toList()));
            TypeMirror superClass = currentTypeElement.getSuperclass();
            if (Elements.superClassIsObject(superClass)) {
                throw new InternalErrorException("Missing validatePartialImplementation call before", new Object[0]);
            }
            if (superClass.toString().equals(baseParentClass.asType().toString())) break;
            currentTypeElement = Elements.asTypeElement(superClass).orElseThrow();
        }
        return methods;
    }
}

