/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.component.impl;

import com.google.inject.Inject;
import io.rxmicro.annotation.processor.common.component.SourceCodeGenerator;
import io.rxmicro.annotation.processor.common.component.impl.BaseProcessorComponent;
import io.rxmicro.annotation.processor.common.model.ClassStructure;
import io.rxmicro.annotation.processor.common.model.DefaultConfigProxyValue;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.common.model.EnvironmentCustomizerClassStructure;
import io.rxmicro.annotation.processor.common.model.ReflectionsClassStructure;
import io.rxmicro.annotation.processor.common.model.SourceCode;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.ProcessingEnvironmentHelper;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;

public abstract class AbstractModuleClassStructuresBuilder
extends BaseProcessorComponent {
    @Inject
    private SourceCodeGenerator sourceCodeGenerator;

    public abstract String getBuilderName();

    public abstract Set<String> getSupportedAnnotationTypes();

    protected abstract Set<? extends ClassStructure> buildClassStructures(EnvironmentContext var1, Set<? extends TypeElement> var2, RoundEnvironment var3);

    protected boolean isEnvironmentCustomizerMustBeGenerated() {
        return true;
    }

    public final List<SourceCode> buildSourceCode(EnvironmentContext environmentContext, Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        HashSet<ClassStructure> classStructures = new HashSet<ClassStructure>(this.buildClassStructures(environmentContext, annotations, roundEnv));
        this.getReflectionStructure(classStructures).ifPresent(classStructures::add);
        if (this.isEnvironmentCustomizerMustBeGenerated()) {
            classStructures.add(this.getEnvironmentCustomizerClassStructure(environmentContext, classStructures));
        }
        this.validateClassStructureDuplicates(environmentContext, classStructures);
        return classStructures.stream().map(cl -> this.sourceCodeGenerator.generate((ClassStructure)cl)).collect(Collectors.toList());
    }

    private void validateClassStructureDuplicates(EnvironmentContext environmentContext, Set<ClassStructure> classStructures) {
        HashMap<String, List> map = new HashMap<String, List>();
        for (ClassStructure classStructure : classStructures) {
            List list = map.computeIfAbsent(classStructure.getTargetFullClassName(), c -> new ArrayList());
            if (list.isEmpty()) {
                list.add(classStructure);
                continue;
            }
            throw new InterruptProcessingException(environmentContext.getCurrentModule(), "Found two different class structures with the same full class name: className='?', structure1='?', structure2='?'! Rename your classes, which are used for generation these structures!", classStructure.getTargetFullClassName(), classStructure.getClass().getName(), ((ClassStructure)list.get(0)).getClass().getName());
        }
    }

    public boolean isUnnamedModuleDisabled() {
        return !this.getBooleanOption("RX_MICRO_BUILD_UNNAMED_MODULE", false);
    }

    public void afterAllClassStructuresBuilt(Set<? extends ClassStructure> classStructures) {
    }

    private Optional<ReflectionsClassStructure> getReflectionStructure(Set<? extends ClassStructure> structures) {
        boolean getterRequired = false;
        boolean setterRequired = false;
        boolean invokeRequired = false;
        for (ClassStructure classStructure : structures) {
            if (classStructure.isRequiredReflectionGetter()) {
                getterRequired = true;
            }
            if (classStructure.isRequiredReflectionSetter()) {
                setterRequired = true;
            }
            if (classStructure.isRequiredReflectionInvoke()) {
                invokeRequired = true;
            }
            if (!getterRequired || !setterRequired || !invokeRequired) continue;
            break;
        }
        if (getterRequired || setterRequired || invokeRequired) {
            return Optional.of(new ReflectionsClassStructure(getterRequired, setterRequired, invokeRequired));
        }
        return Optional.empty();
    }

    private EnvironmentCustomizerClassStructure getEnvironmentCustomizerClassStructure(EnvironmentContext environmentContext, Set<? extends ClassStructure> structures) {
        List<Map.Entry<String, DefaultConfigProxyValue>> defaultConfigValues = Stream.concat(environmentContext.getDefaultConfigValues().stream(), structures.stream().flatMap(classStructure -> classStructure.getDefaultConfigProxyValues().stream())).collect(Collectors.toList());
        return new EnvironmentCustomizerClassStructure(environmentContext.getCurrentModule(), defaultConfigValues, environmentContext.getPackagesThatMustBeOpenedToRxMicroCommonModule());
    }

    protected final boolean isAnnotationPerPackageHierarchyAbsent(TypeElement modelTypeElement, Class<? extends Annotation> annotationClass) {
        PackageElement packageElement1;
        if (modelTypeElement.getAnnotation(annotationClass) != null) {
            return false;
        }
        PackageElement packageElement = (PackageElement)modelTypeElement.getEnclosingElement();
        if (packageElement.getAnnotation(annotationClass) != null) {
            return false;
        }
        Element moduleElement = packageElement.getEnclosingElement();
        if (moduleElement != null && moduleElement.getAnnotation(annotationClass) != null) {
            return false;
        }
        String packageName = packageElement.getQualifiedName().toString();
        do {
            if ((packageName = this.getParentPackageOrNull(packageName)) == null) {
                return true;
            }
            packageElement1 = ProcessingEnvironmentHelper.getElements().getPackageElement(packageName);
            if (packageElement1 != null) continue;
            return true;
        } while (packageElement1.getAnnotation(annotationClass) == null);
        return false;
    }

    private String getParentPackageOrNull(String packageName) {
        int index = packageName.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        return packageName.substring(0, index);
    }

    protected void logClassStructureStorageItem(String name, Set<? extends ClassStructure> classStructures) {
        if (!classStructures.isEmpty() && this.isDebugEnabled()) {
            this.debug("The following ? will be generated:\n?", name, classStructures.stream().map(classStructure -> "  " + classStructure.getLoggableFullClassName()).collect(Collectors.joining("\n")));
        }
    }
}

