/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.component.impl;

import com.google.inject.Inject;
import io.rxmicro.annotation.processor.common.component.IterableContainerElementExtractor;
import io.rxmicro.annotation.processor.common.component.ModelFieldBuilder;
import io.rxmicro.annotation.processor.common.component.impl.BaseProcessorComponent;
import io.rxmicro.annotation.processor.common.model.AnnotatedModelElement;
import io.rxmicro.annotation.processor.common.model.ModelAccessorType;
import io.rxmicro.annotation.processor.common.model.ModelField;
import io.rxmicro.annotation.processor.common.model.ModelFieldBuilderOptions;
import io.rxmicro.annotation.processor.common.model.ModelFieldType;
import io.rxmicro.annotation.processor.common.model.definition.SupportedTypesProvider;
import io.rxmicro.annotation.processor.common.model.error.InternalErrorException;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.model.type.EnumModelClass;
import io.rxmicro.annotation.processor.common.model.type.InternalModelClass;
import io.rxmicro.annotation.processor.common.model.type.IterableModelClass;
import io.rxmicro.annotation.processor.common.model.type.ModelClass;
import io.rxmicro.annotation.processor.common.model.type.ObjectModelClass;
import io.rxmicro.annotation.processor.common.model.type.PrimitiveModelClass;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.common.util.ModelTypeElements;
import io.rxmicro.annotation.processor.common.util.Types;
import io.rxmicro.annotation.processor.common.util.validators.TypeValidators;
import io.rxmicro.common.util.ExCollectors;
import io.rxmicro.common.util.Formats;
import io.rxmicro.model.MappingStrategy;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.lang.model.element.Element;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public abstract class AbstractModelFieldBuilder<MF extends ModelField, MC extends ObjectModelClass<MF>>
extends BaseProcessorComponent
implements ModelFieldBuilder<MF, MC> {
    private int maxNestedLevel = -1;
    @Inject
    private Set<IterableContainerElementExtractor> iterableContainerElementExtractors;

    protected abstract SupportedTypesProvider getSupportedTypesProvider();

    @Override
    public final Map<TypeElement, MC> build(ModelFieldType modelFieldType, ModuleElement currentModule, Set<TypeElement> modelClasses, ModelFieldBuilderOptions options) {
        LinkedHashMap<TypeElement, ObjectModelClass> result = new LinkedHashMap<TypeElement, ObjectModelClass>();
        for (TypeElement typeElement : modelClasses) {
            this.validateModelClass(typeElement);
            ModelClass modelClass = this.extract(currentModule, modelFieldType, typeElement, typeElement.asType(), 0, options);
            if (modelClass.isObject()) {
                ObjectModelClass objectModelClass = (ObjectModelClass)modelClass;
                result.put(typeElement, objectModelClass);
                continue;
            }
            this.error(typeElement, "Invalid model class: ?. Model class could be an json object only", typeElement.getQualifiedName());
        }
        return Collections.unmodifiableMap(result);
    }

    protected final AnnotatedModelElement build(TypeElement typeElement, VariableElement variableElement) {
        return new AnnotatedModelElement(variableElement, Elements.findGetters(typeElement, variableElement), Elements.findSetters(typeElement, variableElement).stream().findFirst().orElse(null));
    }

    protected abstract MF build(ModelFieldType var1, VariableElement var2, TypeElement var3, ModelNames var4, Set<String> var5, int var6, ModelFieldBuilderOptions var7);

    protected void validateModelClass(TypeElement typeElement) {
    }

    protected abstract PrimitiveModelClass createPrimitiveModelClass(TypeMirror var1);

    protected abstract MC createObjectModelClass(ModuleElement var1, ModelFieldType var2, TypeMirror var3, TypeElement var4, int var5, ModelFieldBuilderOptions var6);

    protected Map<MF, ModelClass> getFieldMap(ModuleElement currentModule, ModelFieldType modelFieldType, TypeElement typeElement, int nestedLevel, ModelFieldBuilderOptions options) {
        ModelNames modelNames = new ModelNames();
        HashSet fieldNames = new HashSet();
        return (Map)Elements.allModelFields(typeElement, options.isWithFieldsFromParentClasses()).stream().collect(ExCollectors.toOrderedMap(el -> this.build(modelFieldType, (VariableElement)el, typeElement, modelNames, fieldNames, nestedLevel, options), el -> this.extract(currentModule, modelFieldType, (Element)el, el.asType(), nestedLevel, options)));
    }

    protected final <M extends ModelField> M validateAndReturn(ModelFieldBuilderOptions options, M modelField, TypeElement typeElement) {
        if (options.isAccessViaReflectionMustBeDetected()) {
            String message;
            String link;
            if (modelField.getModelReadAccessorType() == ModelAccessorType.REFLECTION) {
                link = "https://docs.rxmicro.io/latest/user-guide/core.html#core-encapsulation";
                message = Formats.format((String)"PERFORMANCE WARNING: To read a value from ?.? the RxMicro framework will use the reflection. It is recommended to add a getter or change the field modifier: from private to default, protected or public!", (Object[])new Object[]{typeElement.getQualifiedName(), modelField.getFieldName()});
                if (this.getBooleanOption("RX_MICRO_STRICT_MODE", false)) {
                    this.error("https://docs.rxmicro.io/latest/user-guide/core.html#core-encapsulation", modelField.getFieldElement(), message, new Object[0]);
                } else {
                    this.warn("https://docs.rxmicro.io/latest/user-guide/core.html#core-encapsulation", modelField.getFieldElement(), message, new Object[0]);
                }
            }
            if (modelField.getModelWriteAccessorType() == ModelAccessorType.REFLECTION) {
                link = "https://docs.rxmicro.io/latest/user-guide/core.html#core-encapsulation";
                message = Formats.format((String)"PERFORMANCE WARNING: To write a value to ?.? the RxMicro framework will use the reflection. It is recommended to add a setter or change the field modifier: from private to default, protected or public!", (Object[])new Object[]{typeElement.getQualifiedName(), modelField.getFieldName()});
                if (this.getBooleanOption("RX_MICRO_STRICT_MODE", false)) {
                    this.error("https://docs.rxmicro.io/latest/user-guide/core.html#core-encapsulation", modelField.getFieldElement(), message, new Object[0]);
                } else {
                    this.warn("https://docs.rxmicro.io/latest/user-guide/core.html#core-encapsulation", modelField.getFieldElement(), message, new Object[0]);
                }
            }
        }
        return modelField;
    }

    protected final String getModelName(String value, Annotation annotation, String fieldName, Supplier<MappingStrategy> mappingStrategySupplier) {
        if (!value.isEmpty()) {
            return value;
        }
        if (annotation != null) {
            return mappingStrategySupplier.get().getModelName(fieldName);
        }
        return fieldName;
    }

    private ModelClass extract(ModuleElement currentModule, ModelFieldType modelFieldType, Element owner, TypeMirror type, int nestedLevel, ModelFieldBuilderOptions options) {
        if (nestedLevel > this.getMaxNestedLevel()) {
            throw new InterruptProcessingException(owner, "Cycle dependencies detected", new Object[0]);
        }
        if (Types.JAVA_PRIMITIVE_REPLACEMENT.containsKey((Object)type.getKind())) {
            throw new InterruptProcessingException(owner, "Use \"?\" type instead of primitive", Types.JAVA_PRIMITIVE_REPLACEMENT.get((Object)type.getKind()).getName());
        }
        if (type.getKind().isPrimitive()) {
            throw new InterruptProcessingException(owner, "Primitive type for model field not allowed", new Object[0]);
        }
        return this.extractModelClasses(currentModule, modelFieldType, owner, type, nestedLevel, options);
    }

    private ModelClass extractModelClasses(ModuleElement currentModule, ModelFieldType modelFieldType, Element owner, TypeMirror type, int nestedLevel, ModelFieldBuilderOptions options) {
        if (this.getSupportedTypesProvider().isModelInternalType(owner)) {
            return InternalModelClass.create();
        }
        if (this.getSupportedTypesProvider().isModelPrimitive(type)) {
            return Elements.asEnumElement(type).map(e -> new EnumModelClass(type)).orElseGet(() -> this.createPrimitiveModelClass(type));
        }
        if (this.getSupportedTypesProvider().getCollectionContainers().contains(type)) {
            TypeValidators.validateGenericType(owner, type, "Invalid container");
            return this.buildListModelClass(currentModule, modelFieldType, owner, (DeclaredType)type, nestedLevel + 1, options);
        }
        this.getSupportedTypesProvider().getReplacePrimitiveSuggestions(type.toString()).ifPresent(replace -> {
            throw new InterruptProcessingException(owner, "Use '?' type instead of '?' one!", replace.getName(), type.toString());
        });
        TypeElement typeElement = ModelTypeElements.asValidatedModelTypeElement(currentModule, owner, type, "Invalid model class", options);
        return this.createObjectModelClass(currentModule, modelFieldType, type, typeElement, nestedLevel + 1, options);
    }

    private ModelClass buildListModelClass(ModuleElement currentModule, ModelFieldType modelFieldType, Element owner, DeclaredType type, int nestedLevel, ModelFieldBuilderOptions options) {
        IterableContainerElementExtractor iterableContainerElementExtractor = this.getIterableContainerElementExtractor(type);
        TypeMirror itemType = iterableContainerElementExtractor.getItemType(owner, type);
        if (this.getSupportedTypesProvider().isModelPrimitive(itemType)) {
            return Elements.asEnumElement(itemType).map(e -> new IterableModelClass(new EnumModelClass(itemType), type)).orElseGet(() -> new IterableModelClass(this.createPrimitiveModelClass(itemType), type));
        }
        ModelClass elementModelClass = this.extract(currentModule, modelFieldType, owner, itemType, nestedLevel + 1, options);
        if (elementModelClass.isIterable()) {
            throw new InterruptProcessingException(owner, "Multi array does not supported yet", new Object[0]);
        }
        return new IterableModelClass(elementModelClass, type);
    }

    private IterableContainerElementExtractor getIterableContainerElementExtractor(DeclaredType type) {
        return this.iterableContainerElementExtractors.stream().filter(iterableContainerElementExtractor -> iterableContainerElementExtractor.isSupported(type)).findFirst().orElseThrow(() -> {
            throw new InternalErrorException("? instance not configured for '?' type!", IterableContainerElementExtractor.class.getName(), type);
        });
    }

    private int getMaxNestedLevel() {
        if (this.maxNestedLevel == -1) {
            this.maxNestedLevel = this.getIntOption("RX_MICRO_MAX_JSON_NESTED_DEPTH", 20);
        }
        return this.maxNestedLevel;
    }

    public static final class ModelNames {
        private static final Function<String, Set<String>> NEW_SET_CREATOR = n -> new HashSet();
        private final Map<String, Set<String>> models = new HashMap<String, Set<String>>();

        public Set<String> modelNames(String name) {
            return this.models.computeIfAbsent(name, NEW_SET_CREATOR);
        }
    }
}

