/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.component.impl;

import io.rxmicro.annotation.processor.common.component.ModelClassHierarchyBuilder;
import io.rxmicro.annotation.processor.common.component.impl.BaseProcessorComponent;
import io.rxmicro.annotation.processor.common.model.ModelField;
import io.rxmicro.annotation.processor.common.model.type.ModelClass;
import io.rxmicro.annotation.processor.common.model.type.ObjectModelClass;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.common.util.LoggerMessages;
import io.rxmicro.common.util.ExCollections;
import io.rxmicro.common.util.Requires;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public abstract class AbstractModelClassHierarchyBuilder<MF extends ModelField, MC extends ObjectModelClass<MF>>
extends BaseProcessorComponent
implements ModelClassHierarchyBuilder<MF, MC> {
    @Override
    public Optional<List<MC>> build(MC returnedByRestMethodModelClass, Set<String> returnedByRestMethodModelClassNames) {
        LinkedHashMap<String, List<Map.Entry<MF, ModelClass>>> map = new LinkedHashMap<String, List<Map.Entry<MF, ModelClass>>>();
        HashMap<String, TypeElement> typeElementMap = new HashMap<String, TypeElement>();
        String currentClass = ((ObjectModelClass)returnedByRestMethodModelClass).getJavaFullClassName();
        typeElementMap.put(currentClass, ((ObjectModelClass)returnedByRestMethodModelClass).getModelTypeElement());
        for (Map.Entry field : ((ObjectModelClass)returnedByRestMethodModelClass).getAllOrderedDeclaredFields()) {
            TypeElement declaredClass = (TypeElement)((ModelField)field.getKey()).getEnclosingElement();
            if (!declaredClass.getQualifiedName().toString().equals(currentClass)) {
                currentClass = declaredClass.getQualifiedName().toString();
                typeElementMap.put(currentClass, declaredClass);
            }
            map.computeIfAbsent(currentClass, c -> new ArrayList()).add(field);
        }
        if (!map.containsKey(((ObjectModelClass)returnedByRestMethodModelClass).getJavaFullClassName())) {
            map.put(((ObjectModelClass)returnedByRestMethodModelClass).getJavaFullClassName(), List.of());
        }
        if (map.size() == 1) {
            return Optional.empty();
        }
        List<MC> list = this.build(returnedByRestMethodModelClassNames, map, typeElementMap);
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = () -> returnedByRestMethodModelClass.getJavaSimpleClassName();
        supplierArray[1] = () -> this.classHierarchyToString(list);
        this.debug("Resolved the following class hierarchy for '?' model class:\n?", supplierArray);
        return Optional.of(list);
    }

    private List<MC> build(Set<String> notAbstractModelClassNames, Map<String, List<Map.Entry<MF, ModelClass>>> map, Map<String, TypeElement> typeElementMap) {
        LinkedHashMap modelClassMap = new LinkedHashMap();
        for (Map.Entry<String, List<Map.Entry<MF, ModelClass>>> entry : map.entrySet()) {
            TypeElement modelTypeElement = (TypeElement)Requires.require((Object)typeElementMap.get(entry.getKey()));
            boolean modelClassReturnedByRestMethod = notAbstractModelClassNames.contains(entry.getKey());
            Map<ModelField, ModelClass> params = entry.getValue().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Object parentModelClass = this.getNullableParentModelClass(modelTypeElement, modelClassMap);
            if (parentModelClass != null) {
                this.validateParentModelClass(parentModelClass);
            }
            Object modelClass = this.createObjectModelClass(modelTypeElement.asType(), modelTypeElement, params, parentModelClass, modelClassReturnedByRestMethod);
            modelClassMap.put(((ObjectModelClass)modelClass).getJavaFullClassName(), modelClass);
        }
        return ExCollections.unmodifiableList(modelClassMap.values());
    }

    private MC getNullableParentModelClass(TypeElement modelTypeElement, Map<String, MC> modelClassMap) {
        for (String superType : Elements.allSuperTypes(modelTypeElement).stream().map(t -> t.getQualifiedName().toString()).collect(Collectors.toList())) {
            ObjectModelClass mc = (ObjectModelClass)modelClassMap.get(superType);
            if (mc == null) continue;
            return (MC)mc;
        }
        return null;
    }

    protected abstract MC createObjectModelClass(TypeMirror var1, TypeElement var2, Map<MF, ModelClass> var3, MC var4, boolean var5);

    protected abstract void validateParentModelClass(MC var1);

    private String classHierarchyToString(List<MC> list) {
        StringBuilder stringBuilder = new StringBuilder();
        ListIterator<MC> iterator = list.listIterator();
        int index = 0;
        while (iterator.hasNext()) {
            ObjectModelClass parent = (ObjectModelClass)iterator.next();
            if (!iterator.hasNext()) break;
            ObjectModelClass child = (ObjectModelClass)iterator.next();
            stringBuilder.append(LoggerMessages.getLoggableParentChildRelationFragment(index, index == 0, parent, child)).append('\n');
            iterator.previous();
            ++index;
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }
}

