/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.component.impl;

import io.rxmicro.annotation.processor.common.component.impl.BaseProcessorComponent;
import io.rxmicro.annotation.processor.common.model.SupportedAnnotations;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.common.util.validators.MethodValidators;
import io.rxmicro.common.util.Formats;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;

public abstract class AbstractMethodSignatureBuilder
extends BaseProcessorComponent {
    private SupportedAnnotations supportedAnnotations;

    protected abstract Set<Class<? extends Annotation>> getSupportedAnnotationsPerMethod();

    public final SupportedAnnotations getSupportedAnnotations() {
        if (this.supportedAnnotations == null) {
            this.supportedAnnotations = new SupportedAnnotations(this.getSupportedAnnotationsPerMethod());
        }
        return this.supportedAnnotations;
    }

    protected final boolean notContainIn(ExecutableElement method, List<ExecutableElement> methods) {
        if (methods.isEmpty()) {
            return true;
        }
        return methods.stream().noneMatch(otherMethod -> Elements.methodSignatureEquals(method, otherMethod));
    }

    protected final void validateAnnotatedInterfaceMethodModifiers(ExecutableElement method, AnnotationMirror annotation) {
        String errorTemplate = "Annotation '?' couldn't be applied to the ? method. Only ? methods are supported";
        MethodValidators.validateNotPrivateMethod(method, "Annotation '?' couldn't be applied to the ? method. Only ? methods are supported", annotation, "private", "public");
        MethodValidators.validateNotStaticMethod(method, "Annotation '?' couldn't be applied to the ? method. Only ? methods are supported", annotation, "static", "not static");
        MethodValidators.validateNotDefaultMethod(method, "Annotation '?' couldn't be applied to the ? method. Only ? methods are supported", annotation, "default", "abstract");
    }

    protected final void validateAnnotatedClassMethodModifiers(ExecutableElement method, List<? extends AnnotationMirror> annotations) {
        String errorTemplate = "Annotation(s) '?' couldn't be applied to the ? method. Only ? methods are supported";
        String annotationList = annotations.stream().map(a -> Formats.format((String)"@?", (Object[])new Object[]{a.getAnnotationType()})).collect(Collectors.joining(", "));
        MethodValidators.validateNotPrivateMethod(method, "Annotation(s) '?' couldn't be applied to the ? method. Only ? methods are supported", annotationList, "private", "<default> or protected or public");
        MethodValidators.validateNotAbstractMethod(method, "Annotation(s) '?' couldn't be applied to the ? method. Only ? methods are supported", annotationList, "abstract", "not abstract");
        MethodValidators.validateNotStaticMethod(method, "Annotation(s) '?' couldn't be applied to the ? method. Only ? methods are supported", annotationList, "static", "not static");
        MethodValidators.validateNotSynchronizedMethod(method, "Annotation(s) '?' couldn't be applied to the ? method. Only ? methods are supported", annotationList, "synchronized", "not synchronized");
        MethodValidators.validateNotNativeMethod(method, "Annotation(s) '?' couldn't be applied to the ? method. Only ? methods are supported", annotationList, "native", "not native");
    }
}

