/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.component.impl;

import freemarker.cache.TemplateLookupContext;
import freemarker.cache.TemplateLookupResult;
import freemarker.cache.TemplateLookupStrategy;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import io.rxmicro.annotation.processor.common.component.impl.BaseProcessorComponent;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import java.io.IOException;
import java.util.ArrayList;

public abstract class AbstractGenerator
extends BaseProcessorComponent {
    private Configuration cfg;

    protected final Template getTemplate(String name) throws IOException {
        if (this.cfg == null) {
            this.cfg = new Configuration(Configuration.VERSION_2_3_29);
            this.cfg.setClassLoaderForTemplateLoading(this.getClass().getClassLoader(), "ftl");
            this.cfg.setDefaultEncoding("UTF-8");
            this.cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
            this.cfg.setTemplateLookupStrategy(new TemplateLookupStrategy(){

                public TemplateLookupResult lookup(TemplateLookupContext ctx) throws IOException {
                    return ctx.lookupWithAcquisitionStrategy(ctx.getTemplateName());
                }
            });
            this.cfg.setLogTemplateExceptions(false);
            this.cfg.setWrapUncheckedExceptions(true);
            this.cfg.setFallbackOnNullLoopVariable(false);
        }
        return this.cfg.getTemplate(name);
    }

    protected final void catchThrowable(Throwable throwable, Runnable cantGenerateMessageConsumer) {
        if (throwable instanceof TemplateException) {
            TemplateException ex = (TemplateException)throwable;
            InterruptProcessingException interruptProcessingExceptionCause = this.getNullableInterruptProcessingExceptionCause(ex);
            if (interruptProcessingExceptionCause != null) {
                throw interruptProcessingExceptionCause;
            }
            cantGenerateMessageConsumer.run();
        } else {
            cantGenerateMessageConsumer.run();
        }
    }

    private InterruptProcessingException getNullableInterruptProcessingExceptionCause(TemplateException exception) {
        ArrayList<Throwable> throwableList = new ArrayList<Throwable>(2);
        Throwable cause = exception;
        while ((cause = cause.getCause()) != null && !cause.equals((Object)exception) && !throwableList.contains(cause)) {
            if (cause instanceof InterruptProcessingException) {
                return (InterruptProcessingException)((Object)cause);
            }
            throwableList.add(cause);
        }
        return null;
    }
}

