/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common.component.impl;

import io.rxmicro.annotation.processor.common.component.impl.BaseProcessorComponent;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.common.util.Formats;
import java.util.List;
import javax.lang.model.element.Element;

public abstract class AbstractExpressionParser
extends BaseProcessorComponent {
    protected final void extractTemplateAndVariables(Element owner, StringBuilder templateBuilder, List<String> variables, String expression, boolean safeVariableSyntax) {
        StringBuilder variableBuilder = new StringBuilder();
        boolean variableFound = this.extract(owner, templateBuilder, variables, expression, variableBuilder, safeVariableSyntax);
        if (variableFound) {
            throw new InterruptProcessingException(owner, "Invalid expression: '?' -> Missing '}'", expression);
        }
    }

    private boolean extract(Element owner, StringBuilder templateBuilder, List<String> variables, String expression, StringBuilder variableBuilder, boolean safeVariableSyntax) {
        boolean variableFound = false;
        for (int index = 0; index < expression.length(); ++index) {
            char ch = expression.charAt(index);
            if (variableFound) {
                this.validateNotOpenExpression(owner, ch, index, expression);
                if (ch == '}') {
                    variableFound = false;
                    variables.add(safeVariableSyntax ? Formats.format((String)"${?}", (Object[])new Object[]{variableBuilder.toString()}) : variableBuilder.toString());
                    variableBuilder.delete(0, variableBuilder.length());
                    continue;
                }
                variableBuilder.append(ch);
                continue;
            }
            if (ch == '$') {
                if (index < expression.length() - 1) {
                    char next = expression.charAt(index + 1);
                    if (next == '{') {
                        templateBuilder.append('?');
                        ++index;
                        variableFound = true;
                        continue;
                    }
                    this.validateNotOpenExpression(owner, ch, index, expression);
                    continue;
                }
                this.validateNotOpenExpression(owner, ch, index, expression);
                continue;
            }
            this.validateNotOpenExpression(owner, ch, index, expression);
            templateBuilder.append(ch);
        }
        return variableFound;
    }

    private void validateNotOpenExpression(Element owner, char ch, int index, String expression) {
        if (ch == '{') {
            throw new InterruptProcessingException(owner, "Invalid expression: '?' -> Missing '$' before '{'", expression);
        }
        if (ch == '$') {
            if (index < expression.length() - 1) {
                char next = expression.charAt(index + 1);
                if (next == '{') {
                    throw new InterruptProcessingException(owner, "Invalid expression: '?' -> Nested expression not allowed", expression);
                }
                throw new InterruptProcessingException(owner, "Invalid expression: '?' -> Missing '{' after '$'", expression);
            }
            throw new InterruptProcessingException(owner, "Invalid expression: '?' -> Missing '{' after '$'", expression);
        }
    }
}

