/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.common;

import io.rxmicro.annotation.processor.common.component.EnvironmentContextBuilder;
import io.rxmicro.annotation.processor.common.component.impl.AbstractModuleClassStructuresBuilder;
import io.rxmicro.annotation.processor.common.component.impl.AbstractRxMicroProcessor;
import io.rxmicro.annotation.processor.common.model.AnnotationProcessorType;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.common.model.SourceCode;
import io.rxmicro.annotation.processor.common.util.ProcessingEnvironmentHelper;
import io.rxmicro.common.util.Formats;
import io.rxmicro.common.util.Requires;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

public class BaseRxMicroAnnotationProcessor
extends AbstractRxMicroProcessor {
    private final AbstractModuleClassStructuresBuilder moduleClassStructuresBuilder;

    public BaseRxMicroAnnotationProcessor(AbstractModuleClassStructuresBuilder moduleClassStructuresBuilder) {
        this.moduleClassStructuresBuilder = (AbstractModuleClassStructuresBuilder)Requires.require((Object)moduleClassStructuresBuilder);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return this.moduleClassStructuresBuilder.getSupportedAnnotationTypes();
    }

    @Override
    public boolean process(EnvironmentContextBuilder environmentContextBuilder, Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Optional<ModuleElement> moduleElementOptional = this.getCurrentModule(annotations, roundEnv);
        if (moduleElementOptional.isPresent()) {
            ModuleElement currentModule = moduleElementOptional.get();
            if (currentModule.isUnnamed() && this.moduleClassStructuresBuilder.isUnnamedModuleDisabled()) {
                this.displayModuleError();
                return false;
            }
            EnvironmentContext environmentContext = environmentContextBuilder.build(roundEnv, currentModule);
            List<SourceCode> sourceCodes = this.moduleClassStructuresBuilder.buildSourceCode(environmentContext, annotations, roundEnv);
            this.generateClasses(sourceCodes);
            return true;
        }
        this.displayModuleError();
        return false;
    }

    @Override
    protected AnnotationProcessorType getAnnotationProcessorType() {
        return AnnotationProcessorType.PROJECT_COMPILE;
    }

    private void displayModuleError() {
        ProcessingEnvironmentHelper.getMessager().printMessage(Diagnostic.Kind.ERROR, Formats.format((String)"Add `module-info.java` or set compiler option: '?'=true!", (Object[])new Object[]{"RX_MICRO_BUILD_UNNAMED_MODULE"}));
    }

    private Optional<ModuleElement> getCurrentModule(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return annotations.stream().flatMap(a -> roundEnv.getElementsAnnotatedWith((TypeElement)a).stream()).flatMap(e -> Optional.ofNullable(ProcessingEnvironmentHelper.getElements().getModuleOf((Element)e)).stream()).findFirst();
    }
}

