/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.cdi.model;

import io.rxmicro.annotation.processor.cdi.model.InjectionModelField;
import io.rxmicro.annotation.processor.cdi.model.InjectionPointType;
import io.rxmicro.annotation.processor.cdi.model.InjectionResource;
import io.rxmicro.annotation.processor.cdi.model.QualifierRule;
import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.util.ProcessingEnvironmentHelper;
import io.rxmicro.cdi.detail.InternalBeanFactory;
import io.rxmicro.cdi.detail.ResourceLoaderFactory;
import io.rxmicro.common.util.Requires;
import io.rxmicro.config.Configs;
import io.rxmicro.data.RepositoryFactory;
import io.rxmicro.data.mongo.MongoClientFactory;
import io.rxmicro.data.sql.r2dbc.postgresql.PostgreSQLClientFactory;
import io.rxmicro.rest.client.RestClientFactory;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;

public final class InjectionPoint {
    private final boolean constructorInjection;
    private final ExecutableElement injectionMethod;
    private final InjectionPointType type;
    private final boolean required;
    private final InjectionModelField modelField;
    private final List<QualifierRule> qualifierRules;
    private final InjectionResource injectionResource;

    private InjectionPoint(boolean constructorInjection, ExecutableElement injectionMethod, InjectionPointType type, boolean required, InjectionModelField modelField, List<QualifierRule> qualifierRules, InjectionResource injectionResource) {
        this.constructorInjection = constructorInjection;
        this.injectionMethod = injectionMethod;
        this.type = (InjectionPointType)((Object)Requires.require((Object)((Object)type)));
        this.required = required;
        this.modelField = (InjectionModelField)((Object)Requires.require((Object)((Object)modelField)));
        this.qualifierRules = (List)Requires.require(qualifierRules);
        this.injectionResource = injectionResource;
    }

    public boolean isInjectionMethodPresent() {
        return this.injectionMethod != null;
    }

    public String getInjectionMethodSimpleName() {
        return this.injectionMethod.getSimpleName().toString();
    }

    public boolean isRequired() {
        return this.required;
    }

    public InjectionPointType getType() {
        return this.type;
    }

    public InjectionModelField getModelField() {
        return this.modelField;
    }

    public List<QualifierRule> getQualifierRules() {
        return this.qualifierRules;
    }

    public InjectionResource getInjectionResource() {
        return this.injectionResource;
    }

    public void populateClassHeaderBuilder(ClassHeader.Builder classHeaderBuilder) {
        if (this.constructorInjection) {
            classHeaderBuilder.addImports(new TypeMirror[]{ProcessingEnvironmentHelper.getTypes().erasure(this.modelField.getFieldClass())});
        }
        if (this.type == InjectionPointType.MULTI_BINDER) {
            classHeaderBuilder.addImports(new TypeMirror[]{this.modelField.getFieldClass()});
        } else {
            classHeaderBuilder.addImports((String[])this.qualifierRules.stream().flatMap(q -> q.getImports().stream()).toArray(String[]::new));
        }
        if (this.type == InjectionPointType.REPOSITORY) {
            classHeaderBuilder.addStaticImport(RepositoryFactory.class, "getRepository");
            classHeaderBuilder.addImports(new TypeMirror[]{ProcessingEnvironmentHelper.getTypes().erasure(this.modelField.getFieldClass())});
        } else if (this.type == InjectionPointType.CONFIG) {
            classHeaderBuilder.addStaticImport(Configs.class, "getConfig");
            classHeaderBuilder.addImports(new TypeMirror[]{ProcessingEnvironmentHelper.getTypes().erasure(this.modelField.getFieldClass())});
        } else if (this.type == InjectionPointType.MONGO_CLIENT) {
            classHeaderBuilder.addStaticImport(MongoClientFactory.class, "getMongoClient");
        } else if (this.type == InjectionPointType.POSTGRE_SQL_CONNECTION_FACTORY) {
            classHeaderBuilder.addStaticImport(PostgreSQLClientFactory.class, "getPostgreSQLConnectionFactory");
        } else if (this.type == InjectionPointType.POSTGRE_SQL_CONNECTION_POOL) {
            classHeaderBuilder.addStaticImport(PostgreSQLClientFactory.class, "getPostgreSQLConnectionPool");
        } else if (this.type == InjectionPointType.REST_CLIENT) {
            classHeaderBuilder.addStaticImport(RestClientFactory.class, "getRestClient");
            classHeaderBuilder.addImports(new TypeMirror[]{ProcessingEnvironmentHelper.getTypes().erasure(this.modelField.getFieldClass())});
        } else if (this.type == InjectionPointType.BEAN) {
            this.populateBeanClassHeaderBuilder(classHeaderBuilder);
        } else if (this.type == InjectionPointType.MULTI_BINDER) {
            classHeaderBuilder.addStaticImport(InternalBeanFactory.class, "getBeansByType");
        } else if (this.type == InjectionPointType.RESOURCE) {
            this.populateResourceClassHeaderBuilder(classHeaderBuilder);
        }
    }

    private void populateBeanClassHeaderBuilder(ClassHeader.Builder classHeaderBuilder) {
        if (this.required) {
            classHeaderBuilder.addStaticImport(InternalBeanFactory.class, "getRequiredBean");
        } else {
            classHeaderBuilder.addStaticImport(InternalBeanFactory.class, "getOptionalBean");
        }
        classHeaderBuilder.addImports(new TypeMirror[]{ProcessingEnvironmentHelper.getTypes().erasure(this.modelField.getFieldClass())});
    }

    private void populateResourceClassHeaderBuilder(ClassHeader.Builder classHeaderBuilder) {
        if (this.required) {
            classHeaderBuilder.addStaticImport(ResourceLoaderFactory.class, "loadResource");
        } else {
            classHeaderBuilder.addStaticImport(ResourceLoaderFactory.class, "loadOptionalResource");
        }
        classHeaderBuilder.addImports(new String[]{this.injectionResource.getConverterFullClass()});
    }

    public static final class Builder {
        private boolean constructorInjection;
        private ExecutableElement injectionMethod;
        private InjectionPointType type;
        private boolean required;
        private InjectionModelField modelField;
        private List<QualifierRule> qualifierRules = List.of();
        private InjectionResource injectionResource;

        public Builder setConstructorInjection(boolean constructorInjection) {
            this.constructorInjection = constructorInjection;
            return this;
        }

        public Builder setInjectionMethod(ExecutableElement injectionMethod) {
            this.injectionMethod = (ExecutableElement)Requires.require((Object)injectionMethod);
            return this;
        }

        public Builder setType(InjectionPointType type) {
            this.type = (InjectionPointType)((Object)Requires.require((Object)((Object)type)));
            return this;
        }

        public Builder setRequired(boolean required) {
            this.required = required;
            return this;
        }

        public Builder setModelField(InjectionModelField modelField) {
            this.modelField = (InjectionModelField)((Object)Requires.require((Object)((Object)modelField)));
            return this;
        }

        public Builder setQualifierRules(List<QualifierRule> qualifierRules) {
            this.qualifierRules = (List)Requires.require(qualifierRules);
            return this;
        }

        public Builder setInjectionResource(InjectionResource injectionResource) {
            this.injectionResource = (InjectionResource)Requires.require((Object)injectionResource);
            return this;
        }

        public InjectionPoint build() {
            return new InjectionPoint(this.constructorInjection, this.injectionMethod, this.type, this.required, this.modelField, this.qualifierRules, this.injectionResource);
        }
    }
}

