/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.cdi.model;

import io.rxmicro.annotation.processor.cdi.model.BeanDefinition;
import io.rxmicro.annotation.processor.cdi.model.QualifierRule;
import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.model.ClassStructure;
import io.rxmicro.annotation.processor.common.model.ModelAccessorType;
import io.rxmicro.annotation.processor.common.util.GeneratedClassNames;
import io.rxmicro.annotation.processor.common.util.Names;
import io.rxmicro.cdi.detail.BeanSupplier;
import io.rxmicro.common.util.Formats;
import io.rxmicro.common.util.Requires;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public final class BeanSupplierClassStructure
extends ClassStructure {
    private final BeanDefinition beanDefinition;
    private final List<QualifierRule> beanRegistrationQualifierRules;
    private final List<QualifierRule> factoryRegistrationQualifierRules;

    public BeanSupplierClassStructure(BeanDefinition beanDefinition, List<QualifierRule> beanRegistrationQualifierRules, List<QualifierRule> factoryRegistrationQualifierRules) {
        this.beanDefinition = (BeanDefinition)Requires.require((Object)beanDefinition);
        this.beanRegistrationQualifierRules = (List)Requires.require(beanRegistrationQualifierRules);
        this.factoryRegistrationQualifierRules = (List)Requires.require(factoryRegistrationQualifierRules);
    }

    public String getTargetFullClassName() {
        return Formats.format((String)"?.?", (Object[])new Object[]{Names.getPackageName((TypeElement)this.beanDefinition.getBeanTypeElement()), this.getBeanSupplierImplSimpleClassName()});
    }

    public String getTemplateName() {
        return "cdi/$$BeanSupplierTemplate.javaftl";
    }

    public Map<String, Object> getTemplateVariables() {
        return Map.of("JAVA_MODEL_CLASS", this.beanDefinition);
    }

    public ClassHeader getClassHeader() {
        ClassHeader.Builder classHeaderBuilder = ClassHeader.newClassHeaderBuilder((TypeElement)this.beanDefinition.getBeanTypeElement()).addImports(new Class[]{BeanSupplier.class}).addImports(new TypeMirror[]{this.beanDefinition.getBeanTypeElement().asType()});
        this.beanDefinition.populateClassHeaderBuilder(classHeaderBuilder);
        if (this.isRequiredReflectionSetter()) {
            classHeaderBuilder.addStaticImport(GeneratedClassNames.REFLECTIONS_FULL_CLASS_NAME, "setFieldValue");
        }
        if (this.isRequiredReflectionInvoke()) {
            classHeaderBuilder.addStaticImport(GeneratedClassNames.REFLECTIONS_FULL_CLASS_NAME, "invoke");
        }
        return classHeaderBuilder.build();
    }

    public boolean isRequiredReflectionSetter() {
        return this.beanDefinition.getInjectionPoints().stream().anyMatch(injectionPoint -> injectionPoint.getModelField().getModelWriteAccessorType() == ModelAccessorType.REFLECTION);
    }

    public boolean isRequiredReflectionInvoke() {
        return this.beanDefinition.isPostConstructMethodPresent() && this.beanDefinition.getPostConstructMethod().isPrivateMethod() || this.beanDefinition.isFactoryMethodPresent() && this.beanDefinition.getFactoryMethod().isPrivateMethod();
    }

    public String getBeanSupplierImplSimpleClassName() {
        return this.beanDefinition.getBeanSupplierImplSimpleClassName();
    }

    public String getBeanSimpleClassName() {
        return this.beanDefinition.getBeanTypeElement().getSimpleName().toString();
    }

    public List<QualifierRule> getBeanRegistrationQualifierRules() {
        return this.beanRegistrationQualifierRules;
    }

    public List<QualifierRule> getFactoryRegistrationQualifierRules() {
        return this.factoryRegistrationQualifierRules;
    }

    public BeanDefinition getBeanDefinition() {
        return this.beanDefinition;
    }
}

