/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.cdi.model;

import io.rxmicro.annotation.processor.cdi.model.FactoryMethod;
import io.rxmicro.annotation.processor.cdi.model.InjectionPoint;
import io.rxmicro.annotation.processor.cdi.model.PostConstructMethod;
import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.util.GeneratedClassNames;
import io.rxmicro.cdi.detail.BeanSupplier;
import io.rxmicro.cdi.detail.InternalBeanFactory;
import io.rxmicro.common.util.Requires;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

public final class BeanDefinition {
    private final boolean constructorInjection;
    private final TypeElement beanTypeElement;
    private final ExecutableElement factoryTypeProviderMethod;
    private final TypeElement factoryTypeProviderType;
    private final List<InjectionPoint> injectionPoints;
    private final PostConstructMethod postConstructMethod;
    private final FactoryMethod factoryMethod;

    private BeanDefinition(boolean constructorInjection, TypeElement beanTypeElement, ExecutableElement factoryTypeProviderMethod, TypeElement factoryTypeProviderType, List<InjectionPoint> injectionPoints, PostConstructMethod postConstructMethod, FactoryMethod factoryMethod) {
        this.constructorInjection = constructorInjection;
        this.factoryTypeProviderMethod = factoryTypeProviderMethod;
        this.factoryTypeProviderType = factoryTypeProviderType;
        this.beanTypeElement = (TypeElement)Requires.require((Object)beanTypeElement);
        this.injectionPoints = (List)Requires.require(injectionPoints);
        this.postConstructMethod = postConstructMethod;
        this.factoryMethod = factoryMethod;
    }

    public boolean isConstructorInjection() {
        return this.constructorInjection;
    }

    public boolean isFactoryClass() {
        return this.factoryTypeProviderType != null && this.factoryTypeProviderMethod != null;
    }

    public String getFactoryTypeSimpleClassName() {
        return this.factoryTypeProviderType.getSimpleName().toString();
    }

    public String getBeanFactoryTypeSupplierImplSimpleClassName() {
        return GeneratedClassNames.getModelTransformerSimpleClassName((TypeElement)this.factoryTypeProviderType, BeanSupplier.class);
    }

    public List<InjectionPoint> getInjectionPoints() {
        return this.injectionPoints;
    }

    public boolean isPostConstructMethodPresent() {
        return this.postConstructMethod != null;
    }

    public PostConstructMethod getPostConstructMethod() {
        return (PostConstructMethod)Requires.require((Object)this.postConstructMethod);
    }

    public boolean isFactoryMethodPresent() {
        return this.factoryMethod != null;
    }

    public FactoryMethod getFactoryMethod() {
        return (FactoryMethod)Requires.require((Object)this.factoryMethod);
    }

    public String getJavaSimpleClassName() {
        return this.beanTypeElement.getSimpleName().toString();
    }

    public String getBeanSupplierImplSimpleClassName() {
        return GeneratedClassNames.getModelTransformerSimpleClassName((TypeElement)this.beanTypeElement, BeanSupplier.class);
    }

    public TypeElement getBeanTypeElement() {
        return this.beanTypeElement;
    }

    public Optional<TypeElement> getFactoryTypeProviderType() {
        return Optional.ofNullable(this.factoryTypeProviderType);
    }

    public Optional<ExecutableElement> getFactoryTypeProviderMethod() {
        return Optional.ofNullable(this.factoryTypeProviderMethod);
    }

    public void populateClassHeaderBuilder(ClassHeader.Builder classHeaderBuilder) {
        this.injectionPoints.forEach(injectionPoint -> injectionPoint.populateClassHeaderBuilder(classHeaderBuilder));
        if (this.isFactoryClass()) {
            classHeaderBuilder.addImports(new TypeElement[]{this.factoryTypeProviderType}).addStaticImport(InternalBeanFactory.class, "getBean");
        }
    }

    public static final class Builder {
        private boolean constructorInjection;
        private TypeElement beanTypeElement;
        private ExecutableElement factoryTypeProviderMethod;
        private TypeElement factoryTypeProviderType;
        private List<InjectionPoint> injectionPoints;
        private PostConstructMethod postConstructMethod;
        private FactoryMethod factoryMethod;

        public Builder setBeanTypeElement(TypeElement beanTypeElement) {
            this.beanTypeElement = (TypeElement)Requires.require((Object)beanTypeElement);
            return this;
        }

        public Builder setFactoryTypeProviderMethod(ExecutableElement factoryTypeProviderMethod) {
            this.factoryTypeProviderMethod = (ExecutableElement)Requires.require((Object)factoryTypeProviderMethod);
            return this;
        }

        public Builder setFactoryTypeProviderType(TypeElement factoryTypeProviderType) {
            this.factoryTypeProviderType = (TypeElement)Requires.require((Object)factoryTypeProviderType);
            return this;
        }

        public Builder setConstructorInjection(boolean constructorInjection) {
            this.constructorInjection = constructorInjection;
            return this;
        }

        public Builder setInjectionPoints(List<InjectionPoint> injectionPoints) {
            this.injectionPoints = (List)Requires.require(injectionPoints);
            return this;
        }

        public Builder setPostConstructMethod(PostConstructMethod postConstructMethod) {
            this.postConstructMethod = (PostConstructMethod)Requires.require((Object)postConstructMethod);
            return this;
        }

        public Builder setFactoryMethod(FactoryMethod factoryMethod) {
            this.factoryMethod = (FactoryMethod)Requires.require((Object)factoryMethod);
            return this;
        }

        public BeanDefinition build() {
            return new BeanDefinition(this.constructorInjection, this.beanTypeElement, this.factoryTypeProviderMethod, this.factoryTypeProviderType, this.injectionPoints, this.postConstructMethod, this.factoryMethod);
        }
    }
}

