/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.cdi.component.impl.resolver;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.cdi.component.ConverterClassResolver;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.model.virtual.ClassWrapperTypeElement;
import io.rxmicro.cdi.resource.ClasspathPropertiesResourceConverter;
import io.rxmicro.cdi.resource.FilePropertiesResourceConverter;
import io.rxmicro.common.util.Formats;
import java.util.Map;
import java.util.Properties;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

@Singleton
public final class PropertiesResourceConverterClassResolver
implements ConverterClassResolver {
    private static final String PROPERTIES_TYPE = Formats.format((String)"?<?,?>", (Object[])new Object[]{Map.class.getName(), String.class.getName(), String.class.getName()});

    @Override
    public boolean isSupported(String resourcePath) {
        return resourcePath.endsWith(".properties");
    }

    @Override
    public TypeElement resolve(String resourcePath, VariableElement field) {
        String type = field.asType().toString();
        if (PROPERTIES_TYPE.equals(type)) {
            if (resourcePath.startsWith("classpath:")) {
                return new ClassWrapperTypeElement(ClasspathPropertiesResourceConverter.class);
            }
            return new ClassWrapperTypeElement(FilePropertiesResourceConverter.class);
        }
        if (Properties.class.getName().equals(type)) {
            throw new InterruptProcessingException((Element)field, "Use '?' instead of '?' type!", new Object[]{PROPERTIES_TYPE, Properties.class.getSimpleName()});
        }
        throw new InterruptProcessingException((Element)field, "Unsupported resource type. Only '?' supported", new Object[]{PROPERTIES_TYPE});
    }
}

