/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.cdi.component.impl.resolver;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.cdi.component.ConverterClassResolver;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.model.virtual.ClassWrapperTypeElement;
import io.rxmicro.cdi.resource.ClasspathJsonArrayResourceConverter;
import io.rxmicro.cdi.resource.ClasspathJsonObjectResourceConverter;
import io.rxmicro.cdi.resource.FileJsonArrayResourceConverter;
import io.rxmicro.cdi.resource.FileJsonObjectResourceConverter;
import io.rxmicro.common.util.Formats;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

@Singleton
public final class JsonResourceConverterClassResolver
implements ConverterClassResolver {
    private static final String JSON_OBJECT_TYPE = Formats.format((String)"?<?,?>", (Object[])new Object[]{Map.class.getName(), String.class.getName(), Object.class.getName()});
    private static final String JSON_ARRAY_TYPE = Formats.format((String)"?<?>", (Object[])new Object[]{List.class.getName(), Object.class.getName()});

    @Override
    public boolean isSupported(String resourcePath) {
        return resourcePath.endsWith(".json");
    }

    @Override
    public TypeElement resolve(String resourcePath, VariableElement field) {
        String type = field.asType().toString();
        if (JSON_OBJECT_TYPE.equals(type)) {
            if (resourcePath.startsWith("classpath:")) {
                return new ClassWrapperTypeElement(ClasspathJsonObjectResourceConverter.class);
            }
            return new ClassWrapperTypeElement(FileJsonObjectResourceConverter.class);
        }
        if (JSON_ARRAY_TYPE.equals(type)) {
            if (resourcePath.startsWith("classpath:")) {
                return new ClassWrapperTypeElement(ClasspathJsonArrayResourceConverter.class);
            }
            return new ClassWrapperTypeElement(FileJsonArrayResourceConverter.class);
        }
        throw new InterruptProcessingException((Element)field, "Unsupported resource type. Only '?' and '?' supported", new Object[]{JSON_OBJECT_TYPE, JSON_ARRAY_TYPE});
    }
}

