/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.cdi.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.cdi.component.UserDefinedNameBuilder;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.ProcessingEnvironmentHelper;
import io.rxmicro.annotation.processor.common.util.validators.AnnotationValidators;
import io.rxmicro.cdi.local.Annotations;
import io.rxmicro.common.util.Strings;
import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

@Singleton
public final class UserDefinedNameBuilderImpl
implements UserDefinedNameBuilder {
    @Override
    public Optional<String> getName(Element element) {
        List<Map.Entry<TypeMirror, String>> qualifiedNames = this.getAllQualifiedNamesDefinedByUser(element);
        this.validate(element, qualifiedNames, () -> qualifiedNames.stream().map(Map.Entry::getKey).collect(Collectors.toList()));
        return qualifiedNames.stream().map(Map.Entry::getValue).findFirst();
    }

    private List<Map.Entry<TypeMirror, String>> getAllQualifiedNamesDefinedByUser(Element element) {
        ArrayList<Map.Entry<TypeMirror, String>> result = new ArrayList<Map.Entry<TypeMirror, String>>();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (Annotations.QUALIFIER_ANNOTATIONS.stream().anyMatch(cl -> cl.getName().equals(annotation.getAnnotationType().toString()))) {
                String annotationValue = (String)io.rxmicro.annotation.processor.common.util.Annotations.getAnnotationValue(ProcessingEnvironmentHelper.getElements().getElementValuesWithDefaults(annotationMirror));
                this.validateNotEmpty(element, annotationValue);
                this.validateStringQualifier(element, annotationValue);
                result.add(Map.entry(annotationMirror.getAnnotationType(), annotationValue));
                continue;
            }
            this.getCustomQualifierAnnotationValue(annotationMirror).ifPresent(value -> result.add(Map.entry(annotation.getAnnotationType(), value)));
        }
        return result;
    }

    private Optional<String> getCustomQualifierAnnotationValue(AnnotationMirror annotation) {
        TypeElement annotationElement = io.rxmicro.annotation.processor.common.util.Annotations.getAnnotationElement((AnnotationMirror)annotation);
        List mirrors = annotationElement.getAnnotationMirrors().stream().filter(a -> Annotations.QUALIFIER_ANNOTATIONS.stream().anyMatch(cl -> cl.getName().equals(a.getAnnotationType().toString()))).collect(Collectors.toList());
        if (!mirrors.isEmpty()) {
            this.validate(annotationElement, mirrors, () -> Annotations.QUALIFIER_ANNOTATIONS.stream().map(Class::getName).collect(Collectors.toList()));
            AnnotationValidators.validateCustomAnnotation((TypeElement)annotationElement, Set.of(ElementType.FIELD, ElementType.METHOD, ElementType.TYPE, ElementType.PARAMETER, ElementType.CONSTRUCTOR));
        }
        return mirrors.stream().findFirst().map(a -> (String)io.rxmicro.annotation.processor.common.util.Annotations.getAnnotationValue(ProcessingEnvironmentHelper.getElements().getElementValuesWithDefaults((AnnotationMirror)a))).map(value -> Optional.of(value).filter(v -> !v.isEmpty()).map(v -> {
            this.validateStringQualifier(annotationElement, (String)v);
            this.validateNoAnnotationParameters(annotationElement);
            return v;
        }).orElseGet(() -> this.buildAnnotationTypeQualifierName(annotation)));
    }

    private void validate(Element owner, Collection<?> qualifiedNames, Supplier<List<?>> allowedAnnotationsSupplier) {
        if (qualifiedNames.size() > 1) {
            throw new InterruptProcessingException(owner, "Redundant qualifier annotation per element. Use only one annotation from the list: ?!", new Object[]{allowedAnnotationsSupplier.get()});
        }
    }

    private void validateStringQualifier(Element element, String annotationValue) {
        if (Strings.startsWith((String)annotationValue, (char)'@')) {
            throw new InterruptProcessingException(element, "String qualifier couldn't start with '@' character. Remote invalid character!", new Object[0]);
        }
    }

    private void validateNotEmpty(Element element, String annotationValue) {
        if (annotationValue.isBlank()) {
            throw new InterruptProcessingException(element, "String qualifier couldn't be empty. Add qualifier name!", new Object[0]);
        }
    }

    private void validateNoAnnotationParameters(TypeElement annotationElement) {
        if (!annotationElement.getEnclosedElements().isEmpty()) {
            throw new InterruptProcessingException((Element)annotationElement, "Custom qualifier annotation with specified string qualifier name must not contain any parameters. Remove all annotation parameters!", new Object[0]);
        }
    }

    private String buildAnnotationTypeQualifierName(AnnotationMirror annotation) {
        StringBuilder builder = new StringBuilder("@");
        builder.append(annotation.getAnnotationType());
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = ProcessingEnvironmentHelper.getElements().getElementValuesWithDefaults(annotation);
        if (!elementValues.isEmpty()) {
            builder.append('(');
            boolean entryAdded = false;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
                if (entryAdded) {
                    builder.append(',');
                }
                builder.append(entry.getKey().getSimpleName()).append('=').append(entry.getValue().getValue());
                entryAdded = true;
            }
            builder.append(')');
        }
        return builder.toString();
    }
}

