/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.cdi.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.cdi.component.PostConstructMethodFinder;
import io.rxmicro.annotation.processor.cdi.model.PostConstructMethod;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.common.util.validators.MethodValidators;
import io.rxmicro.cdi.PostConstruct;
import io.rxmicro.common.util.Formats;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;

@Singleton
public final class PostConstructMethodFinderImpl
implements PostConstructMethodFinder {
    @Override
    public Optional<PostConstructMethod> findMethod(TypeElement beanTypeElement) {
        List methods = Elements.allMethods((TypeElement)beanTypeElement, el -> el.getSimpleName().toString().equals("postConstruct") || el.getAnnotation(PostConstruct.class) != null);
        this.validateMethods(methods);
        if (methods.size() > 1) {
            throw new InterruptProcessingException((Element)methods.get(0), "Only one post construct method allowed per class. Remove the following methods: ?", new Object[]{methods.stream().skip(1L).map(e -> Formats.format((String)"?.?(?)", (Object[])new Object[]{e.getEnclosingElement().asType().toString(), e.getSimpleName(), e.getParameters().stream().map(v -> v.asType().toString()).collect(Collectors.joining(", "))})).collect(Collectors.toList())});
        }
        return methods.stream().findFirst().map(PostConstructMethod::new);
    }

    private void validateMethods(List<ExecutableElement> methods) {
        for (ExecutableElement method : methods) {
            MethodValidators.validateNotStaticMethod((ExecutableElement)method, (String)"Post construct method couldn't be static.", (Object[])new Object[0]);
            MethodValidators.validateNotAbstractMethod((ExecutableElement)method, (String)"Post construct method couldn't be abstract.", (Object[])new Object[0]);
            MethodValidators.validateNotNativeMethod((ExecutableElement)method, (String)"Post construct method couldn't be native.", (Object[])new Object[0]);
            MethodValidators.validateNotSynchronizedMethod((ExecutableElement)method, (String)"Post construct method couldn't be synchronized.", (Object[])new Object[0]);
            MethodValidators.validateWithoutParametersMethod((ExecutableElement)method, (String)"Post construct method couldn't contain any parameters.", (Object[])new Object[0]);
            if (method.getReturnType().getKind() == TypeKind.VOID) continue;
            throw new InterruptProcessingException((Element)method, "Post construct method must return 'void'", new Object[0]);
        }
    }
}

